/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.commerce.inventory.web.internal.portlet.action;

import com.liferay.commerce.inventory.exception.DuplicateCommerceInventoryWarehouseItemException;
import com.liferay.commerce.inventory.model.CommerceInventoryWarehouseItem;
import com.liferay.commerce.inventory.service.CommerceInventoryWarehouseItemService;
import com.liferay.commerce.product.constants.CPPortletKeys;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.bridges.mvc.BaseMVCActionCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.Constants;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;

import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;

import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

/**
 * @author Alessio Antonio Rendina
 */
@Component(
	immediate = true,
	property = {
		"javax.portlet.name=" + CPPortletKeys.COMMERCE_INVENTORY,
		"mvc.command.name=editCommerceInventoryWarehouse"
	},
	service = MVCActionCommand.class
)
public class EditCommerceInventoryWarehouseMVCActionCommand
	extends BaseMVCActionCommand {

	protected void addCommerceInventoryWarehouse(ActionRequest actionRequest)
		throws PortalException {

		long commerceInventoryWarehouseId = ParamUtil.getLong(
			actionRequest, "commerceInventoryWarehouseId");

		String sku = ParamUtil.getString(actionRequest, "sku");

		int quantity = ParamUtil.getInteger(actionRequest, "quantity");

		ServiceContext serviceContext = ServiceContextFactory.getInstance(
			CommerceInventoryWarehouseItem.class.getName(), actionRequest);

		_commerceInventoryWarehouseItemService.
			addCommerceInventoryWarehouseItem(
				serviceContext.getUserId(), commerceInventoryWarehouseId, sku,
				quantity);
	}

	protected void deleteCommerceInventoryWarehouse(ActionRequest actionRequest)
		throws PortalException {

		String sku = ParamUtil.getString(actionRequest, "sku");

		_commerceInventoryWarehouseItemService.
			deleteCommerceInventoryWarehouseItems(
				_portal.getCompanyId(actionRequest), sku);
	}

	@Override
	protected void doProcessAction(
			ActionRequest actionRequest, ActionResponse actionResponse)
		throws Exception {

		String cmd = ParamUtil.getString(actionRequest, Constants.CMD);

		try {
			if (cmd.equals(Constants.ADD)) {
				addCommerceInventoryWarehouse(actionRequest);
			}
			else if (cmd.equals(Constants.DELETE)) {
				deleteCommerceInventoryWarehouse(actionRequest);
			}
			else if (cmd.equals(Constants.UPDATE)) {
				updateCommerceInventoryWarehouse(actionRequest);
			}
		}
		catch (Exception e) {
			if (e instanceof DuplicateCommerceInventoryWarehouseItemException) {
				SessionErrors.add(actionRequest, e.getClass());

				String redirect = ParamUtil.getString(
					actionRequest, "redirect");

				sendRedirect(actionRequest, actionResponse, redirect);
			}
			else {
				_log.error(e, e);
			}
		}
	}

	protected void updateCommerceInventoryWarehouse(ActionRequest actionRequest)
		throws PortalException {

		long commerceInventoryWarehouseId = ParamUtil.getLong(
			actionRequest, "commerceInventoryWarehouseId");

		String sku = ParamUtil.getString(actionRequest, "sku");

		int quantity = ParamUtil.getInteger(actionRequest, "quantity");

		CommerceInventoryWarehouseItem commerceInventoryWarehouseItem =
			_commerceInventoryWarehouseItemService.
				fetchCommerceInventoryWarehouseItem(
					commerceInventoryWarehouseId, sku);

		if (commerceInventoryWarehouseItem == null) {
			ServiceContext serviceContext = ServiceContextFactory.getInstance(
				CommerceInventoryWarehouseItem.class.getName(), actionRequest);

			_commerceInventoryWarehouseItemService.
				addCommerceInventoryWarehouseItem(
					serviceContext.getUserId(), commerceInventoryWarehouseId,
					sku, quantity);
		}
		else {
			_commerceInventoryWarehouseItemService.
				increaseCommerceInventoryWarehouseItemQuantity(
					commerceInventoryWarehouseItem.
						getCommerceInventoryWarehouseItemId(),
					quantity);
		}
	}

	private static final Log _log = LogFactoryUtil.getLog(
		EditCommerceInventoryWarehouseMVCActionCommand.class);

	@Reference
	private CommerceInventoryWarehouseItemService
		_commerceInventoryWarehouseItemService;

	@Reference
	private Portal _portal;

}