/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.inventory.web.internal.portlet.action;

import com.liferay.commerce.exception.NoSuchCPDefinitionInventoryException;
import com.liferay.commerce.model.CPDefinitionInventory;
import com.liferay.commerce.service.CPDAvailabilityEstimateService;
import com.liferay.commerce.service.CPDefinitionInventoryService;
import com.liferay.portal.kernel.portlet.bridges.mvc.BaseMVCActionCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.ParamUtil;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_commerce_product_definitions_web_internal_portlet_CPDefinitionsPortlet", "mvc.command.name=editProductDefinitionInventory"}, service={MVCActionCommand.class})
public class EditCPDefinitionInventoryMVCActionCommand
extends BaseMVCActionCommand {
    @Reference
    private CPDAvailabilityEstimateService _cpdAvailabilityEstimateService;
    @Reference
    private CPDefinitionInventoryService _cpDefinitionInventoryService;

    protected void doProcessAction(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            if (cmd.equals("add") || cmd.equals("update")) {
                this.updateCPDefinitionInventory(actionRequest);
            }
        }
        catch (Exception e) {
            if (e instanceof NoSuchCPDefinitionInventoryException || e instanceof NumberFormatException || e instanceof PrincipalException) {
                this.hideDefaultErrorMessage((PortletRequest)actionRequest);
                this.hideDefaultSuccessMessage((PortletRequest)actionRequest);
                SessionErrors.add((PortletRequest)actionRequest, e.getClass());
                String redirect = ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect");
                this.sendRedirect(actionRequest, actionResponse, redirect);
            }
            throw e;
        }
    }

    protected void updateCPDefinitionInventory(ActionRequest actionRequest) throws Exception {
        long cpDefinitionInventoryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"cpDefinitionInventoryId");
        long cpdAvailabilityEstimateEntryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"cpdAvailabilityEstimateEntryId");
        long cpDefinitionId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"cpDefinitionId");
        String cpDefinitionInventoryEngine = ParamUtil.getString((PortletRequest)actionRequest, (String)"CPDefinitionInventoryEngine");
        String lowStockActivity = ParamUtil.getString((PortletRequest)actionRequest, (String)"lowStockActivity");
        long commerceAvailabilityEstimateId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"commerceAvailabilityEstimateId");
        boolean displayAvailability = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"displayAvailability");
        boolean displayStockQuantity = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"displayStockQuantity");
        boolean backOrders = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"backOrders");
        String minStockQuantityString = ParamUtil.getString((PortletRequest)actionRequest, (String)"minStockQuantity");
        String minOrderQuantityString = ParamUtil.getString((PortletRequest)actionRequest, (String)"minOrderQuantity");
        String maxOrderQuantityString = ParamUtil.getString((PortletRequest)actionRequest, (String)"maxOrderQuantity");
        String multipleOrderQuantityString = ParamUtil.getString((PortletRequest)actionRequest, (String)"multipleOrderQuantity");
        int minStockQuantity = Integer.valueOf(minStockQuantityString);
        int minOrderQuantity = Integer.valueOf(minOrderQuantityString);
        int maxOrderQuantity = Integer.valueOf(maxOrderQuantityString);
        int multipleOrderQuantity = Integer.valueOf(multipleOrderQuantityString);
        String allowedOrderQuantities = ParamUtil.getString((PortletRequest)actionRequest, (String)"allowedOrderQuantities");
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)CPDefinitionInventory.class.getName(), (PortletRequest)actionRequest);
        if (cpDefinitionInventoryId <= 0L) {
            this._cpDefinitionInventoryService.addCPDefinitionInventory(cpDefinitionId, cpDefinitionInventoryEngine, lowStockActivity, displayAvailability, displayStockQuantity, minStockQuantity, backOrders, minOrderQuantity, maxOrderQuantity, allowedOrderQuantities, multipleOrderQuantity, serviceContext);
        } else {
            this._cpDefinitionInventoryService.updateCPDefinitionInventory(cpDefinitionInventoryId, cpDefinitionInventoryEngine, lowStockActivity, displayAvailability, displayStockQuantity, minStockQuantity, backOrders, minOrderQuantity, maxOrderQuantity, allowedOrderQuantities, multipleOrderQuantity, serviceContext);
        }
        this._cpdAvailabilityEstimateService.updateCPDAvailabilityEstimate(cpdAvailabilityEstimateEntryId, cpDefinitionId, commerceAvailabilityEstimateId, serviceContext);
    }
}

