/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.inventory.web.internal.servlet.taglib;

import com.liferay.commerce.inventory.engine.CommerceInventoryEngine;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.taglib.BaseJSPDynamicInclude;
import com.liferay.portal.kernel.servlet.taglib.DynamicInclude;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={DynamicInclude.class})
public class InventoryDataJSPDynamicInclude
extends BaseJSPDynamicInclude {
    private static final Log _log = LogFactoryUtil.getLog(InventoryDataJSPDynamicInclude.class);
    @Reference
    private CommerceInventoryEngine _commerceInventoryEngine;

    public void include(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String key) throws IOException {
        try {
            CPInstance cpInstance = (CPInstance)httpServletRequest.getAttribute("inventory-cpInstance");
            int cpInstanceQuantity = this._commerceInventoryEngine.getStockQuantity(cpInstance.getCompanyId(), cpInstance.getSku());
            PrintWriter printWriter = httpServletResponse.getWriter();
            printWriter.println(cpInstanceQuantity);
        }
        catch (PortalException pe) {
            _log.error((Object)pe, (Throwable)pe);
        }
    }

    public void register(DynamicInclude.DynamicIncludeRegistry dynamicIncludeRegistry) {
        dynamicIncludeRegistry.register("com.liferay.commerce.inventory.web#/inventory_data#");
    }

    protected String getJspPath() {
        return null;
    }

    protected Log getLog() {
        return _log;
    }

    @Reference(target="(osgi.web.symbolicname=com.liferay.commerce.inventory.web)", unbind="-")
    protected void setServletContext(ServletContext servletContext) {
        super.setServletContext(servletContext);
    }
}

