/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.initializer.breccia.internal;

import com.liferay.commerce.currency.service.CommerceCurrencyLocalService;
import com.liferay.commerce.initializer.util.AssetCategoriesImporter;
import com.liferay.commerce.initializer.util.CPDefinitionsImporter;
import com.liferay.commerce.initializer.util.CPOptionCategoriesImporter;
import com.liferay.commerce.initializer.util.CPOptionsImporter;
import com.liferay.commerce.initializer.util.CPRulesImporter;
import com.liferay.commerce.initializer.util.CPSpecificationOptionsImporter;
import com.liferay.commerce.initializer.util.CommerceWarehousesImporter;
import com.liferay.commerce.initializer.util.PortletSettingsImporter;
import com.liferay.commerce.model.CommerceWarehouse;
import com.liferay.commerce.product.importer.CPFileImporter;
import com.liferay.commerce.product.service.CPMeasurementUnitLocalService;
import com.liferay.commerce.service.CommerceCountryLocalService;
import com.liferay.commerce.user.segment.service.CommerceUserSegmentEntryLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.Theme;
import com.liferay.portal.kernel.model.ThemeSetting;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portlet.PortletIdCodec;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ThemeLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.Accessor;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.site.exception.InitializationException;
import com.liferay.site.initializer.SiteInitializer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.portlet.PortletPreferences;
import javax.servlet.ServletContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"site.initializer.key=breccia-initializer"}, service={SiteInitializer.class})
public class BrecciaSiteInitializer
implements SiteInitializer {
    public static final String KEY = "breccia-initializer";
    private static final String _BRECCIA_THEME_ID = "breccia_WAR_commercebrecciatheme";
    private static final String _COMMERCE_VOCABULARY = "Commerce";
    private static final String _DEPENDENCIES_PATH = "com/liferay/commerce/initializer/breccia/internal/dependencies/";
    private static final String _SITE_NAVIGATION_MENU_PORTLET_NAME = "com_liferay_site_navigation_menu_web_portlet_SiteNavigationMenuPortlet";
    private static final Log _log = LogFactoryUtil.getLog(BrecciaSiteInitializer.class);
    @Reference
    private AssetCategoriesImporter _assetCategoriesImporter;
    @Reference
    private CommerceCountryLocalService _commerceCountryLocalService;
    @Reference
    private CommerceCurrencyLocalService _commerceCurrencyLocalService;
    @Reference
    private CommerceUserSegmentEntryLocalService _commerceUserSegmentEntryLocalService;
    @Reference
    private CommerceWarehousesImporter _commerceWarehousesImporter;
    @Reference
    private CPDefinitionsImporter _cpDefinitionsImporter;
    @Reference
    private CPFileImporter _cpFileImporter;
    @Reference
    private CPMeasurementUnitLocalService _cpMeasurementUnitLocalService;
    @Reference
    private CPOptionCategoriesImporter _cpOptionCategoriesImporter;
    @Reference
    private CPOptionsImporter _cpOptionsImporter;
    @Reference
    private CPRulesImporter _cpRulesImporter;
    @Reference
    private CPSpecificationOptionsImporter _cpSpecificationOptionsImporter;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private PortletSettingsImporter _portletSettingsImporter;
    @Reference(target="(osgi.web.symbolicname=com.liferay.commerce.initializer.breccia)")
    private ServletContext _servletContext;
    @Reference
    private ThemeLocalService _themeLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public String getDescription(Locale locale) {
        ResourceBundle resourceBundle = ResourceBundleUtil.getBundle((String)"content.Language", (Locale)locale, this.getClass());
        return LanguageUtil.get((ResourceBundle)resourceBundle, (String)"breccia-description");
    }

    public String getKey() {
        return KEY;
    }

    public String getName(Locale locale) {
        ResourceBundle resourceBundle = ResourceBundleUtil.getBundle((String)"content.Language", (Locale)locale, this.getClass());
        return LanguageUtil.get((ResourceBundle)resourceBundle, (String)"breccia");
    }

    public String getThumbnailSrc() {
        return this._servletContext.getContextPath() + "/images/Breccia-Logo-Square.jpg";
    }

    public void initialize(long groupId) throws InitializationException {
        try {
            this._initialize(groupId);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new InitializationException((Throwable)e);
        }
    }

    public boolean isActive(long companyId) {
        Theme theme = this._themeLocalService.fetchTheme(companyId, _BRECCIA_THEME_ID);
        if (theme == null) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)"breccia_WAR_commercebrecciatheme is not registered");
            }
            return false;
        }
        return true;
    }

    private void _cleanLayouts(ServiceContext serviceContext) throws PortalException {
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Cleaning layouts...");
        }
        this._cpFileImporter.cleanLayouts(serviceContext);
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Layouts successfully cleaned");
        }
    }

    private String _getJSON(String name) throws IOException {
        return StringUtil.read((ClassLoader)BrecciaSiteInitializer.class.getClassLoader(), (String)(_DEPENDENCIES_PATH + name));
    }

    private JSONArray _getJSONArray(String name) throws Exception {
        String json = this._getJSON(name);
        return this._jsonFactory.createJSONArray(json);
    }

    private JSONObject _getJSONObject(String name) throws Exception {
        String json = this._getJSON(name);
        return this._jsonFactory.createJSONObject(json);
    }

    private ServiceContext _getServiceContext(long groupId) throws PortalException {
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddGroupPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        Group group = this._groupLocalService.getGroup(groupId);
        serviceContext.setCompanyId(group.getCompanyId());
        Locale locale = LocaleUtil.getSiteDefault();
        serviceContext.setLanguageId(LanguageUtil.getLanguageId((Locale)locale));
        serviceContext.setScopeGroupId(groupId);
        User user = this._userLocalService.getUser(PrincipalThreadLocal.getUserId());
        serviceContext.setTimeZone(user.getTimeZone());
        serviceContext.setUserId(user.getUserId());
        return serviceContext;
    }

    private void _importAssetCategories(ServiceContext serviceContext) throws Exception {
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Importing asset categories...");
        }
        ClassLoader classLoader = BrecciaSiteInitializer.class.getClassLoader();
        String json = StringUtil.read((ClassLoader)classLoader, (String)"com/liferay/commerce/initializer/breccia/internal/dependencies/categories.json");
        JSONArray jsonArray = this._jsonFactory.createJSONArray(json);
        this._assetCategoriesImporter.importAssetCategories(jsonArray, _COMMERCE_VOCABULARY, classLoader, "com/liferay/commerce/initializer/breccia/internal/dependencies/images/", serviceContext.getScopeGroupId(), serviceContext.getUserId(), true);
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Asset categories successfully imported");
        }
    }

    private List<CommerceWarehouse> _importCommerceWarehouses(ServiceContext serviceContext) throws Exception {
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Importing commerce warehouses...");
        }
        this._commerceWarehousesImporter.importDefaultCommerceWarehouse(serviceContext.getScopeGroupId(), serviceContext.getUserId());
        JSONArray jsonArray = this._getJSONArray("warehouses.json");
        List commerceWarehouses = this._commerceWarehousesImporter.importCommerceWarehouses(jsonArray, serviceContext.getScopeGroupId(), serviceContext.getUserId());
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Commerce warehouses successfully imported");
        }
        return commerceWarehouses;
    }

    private void _importCPDefinitions(List<CommerceWarehouse> commerceWarehouses, ServiceContext serviceContext) throws Exception {
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Importing commerce product definitions...");
        }
        JSONArray jsonArray = this._getJSONArray("products.json");
        long[] commerceWarehouseIds = ListUtil.toLongArray(commerceWarehouses, (Accessor)CommerceWarehouse.COMMERCE_WAREHOUSE_ID_ACCESSOR);
        this._cpDefinitionsImporter.importCPDefinitions(jsonArray, _COMMERCE_VOCABULARY, commerceWarehouseIds, BrecciaSiteInitializer.class.getClassLoader(), "com/liferay/commerce/initializer/breccia/internal/dependencies/images/", serviceContext.getScopeGroupId(), serviceContext.getUserId());
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Commerce product definitions successfully imported");
        }
    }

    private void _importCPOptionCategories(ServiceContext serviceContext) throws Exception {
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Importing commerce product option categories...");
        }
        JSONArray jsonArray = this._getJSONArray("option-categories.json");
        this._cpOptionCategoriesImporter.importCPOptionCategories(jsonArray, serviceContext.getScopeGroupId(), serviceContext.getUserId());
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Commerce product option categories successfully imported");
        }
    }

    private void _importCPOptions(ServiceContext serviceContext) throws Exception {
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Importing commerce product options...");
        }
        JSONArray jsonArray = this._getJSONArray("options.json");
        this._cpOptionsImporter.importCPOptions(jsonArray, serviceContext.getScopeGroupId(), serviceContext.getUserId());
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Commerce product options successfully imported");
        }
    }

    private void _importCPRules(ServiceContext serviceContext) throws Exception {
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Importing catalog rules...");
        }
        JSONArray jsonArray = this._getJSONArray("catalog-rules.json");
        this._cpRulesImporter.importCPRules(jsonArray, serviceContext.getScopeGroupId(), serviceContext.getUserId());
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Catalog rules successfully imported");
        }
    }

    private void _importCPSpecificationOptions(ServiceContext serviceContext) throws Exception {
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Importing commerce product specification options...");
        }
        JSONArray jsonArray = this._getJSONArray("specification-options.json");
        this._cpSpecificationOptionsImporter.importCPSpecificationOptions(jsonArray, serviceContext.getScopeGroupId(), serviceContext.getUserId());
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Commerce product specification options successfully imported");
        }
    }

    private void _importDefaultCommerceCountries(ServiceContext serviceContext) throws Exception {
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Importing default commerce countries...");
        }
        this._commerceCountryLocalService.importDefaultCountries(serviceContext);
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Commerce countries successfully imported");
        }
    }

    private void _importDefaultCommerceCurrencies(ServiceContext serviceContext) throws Exception {
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Importing default commerce currencies...");
        }
        this._commerceCurrencyLocalService.importDefaultValues(serviceContext);
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Commerce currencies successfully imported");
        }
    }

    private void _importDefaultCPMeasurementUnits(ServiceContext serviceContext) throws PortalException {
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Importing commerce product measurement units...");
        }
        this._cpMeasurementUnitLocalService.importDefaultValues(serviceContext);
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Commerce product measurement units successfully imported");
        }
    }

    private void _importJournalArticles(ServiceContext serviceContext) throws Exception {
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Importing journal articles...");
        }
        JSONArray jsonArray = this._getJSONArray("journal-articles.json");
        this._cpFileImporter.createJournalArticles(jsonArray, BrecciaSiteInitializer.class.getClassLoader(), "com/liferay/commerce/initializer/breccia/internal/dependencies/journal_articles/", serviceContext);
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Journal articles successfully imported");
        }
    }

    private void _importLayouts(ServiceContext serviceContext) throws Exception {
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Importing layouts...");
        }
        ClassLoader classLoader = BrecciaSiteInitializer.class.getClassLoader();
        String json = StringUtil.read((ClassLoader)classLoader, (String)"com/liferay/commerce/initializer/breccia/internal/dependencies/layouts.json");
        JSONArray jsonArray = this._jsonFactory.createJSONArray(json);
        this._cpFileImporter.createLayouts(jsonArray, classLoader, _DEPENDENCIES_PATH, serviceContext);
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Layouts successfully imported");
        }
    }

    private void _importPortletSettings(ServiceContext serviceContext) throws Exception {
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Importing portlet settings...");
        }
        JSONArray jsonArray = this._getJSONArray("portlet-settings.json");
        this._portletSettingsImporter.importPortletSettings(jsonArray, BrecciaSiteInitializer.class.getClassLoader(), "com/liferay/commerce/initializer/breccia/internal/dependencies/display_templates/", serviceContext.getScopeGroupId(), serviceContext.getUserId());
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Portlet settings successfully imported");
        }
    }

    private void _importSiteNavigationMenuPortletSettings(JSONObject jsonObject, String portletName, ServiceContext serviceContext) throws Exception {
        if (portletName.equals(_SITE_NAVIGATION_MENU_PORTLET_NAME)) {
            Layout layout;
            String instanceId = jsonObject.getString("instanceId");
            String layoutFriendlyURL = jsonObject.getString("layoutFriendlyURL");
            String rootLayoutFriendlyURL = jsonObject.getString("rootLayoutFriendlyURL");
            JSONObject portletPreferencesJSONObject = jsonObject.getJSONObject("portletPreferences");
            Layout rootLayout = null;
            if (Validator.isNotNull((String)rootLayoutFriendlyURL)) {
                rootLayout = this._layoutLocalService.fetchLayoutByFriendlyURL(serviceContext.getScopeGroupId(), false, rootLayoutFriendlyURL);
            }
            String portletId = PortletIdCodec.encode((String)portletName, (String)instanceId);
            PortletPreferences portletSetup = PortletPreferencesFactoryUtil.getLayoutPortletSetup((long)serviceContext.getCompanyId(), (long)serviceContext.getScopeGroupId(), (int)3, (long)0L, (String)portletId, (String)"");
            Iterator iterator = portletPreferencesJSONObject.keys();
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                String value = portletPreferencesJSONObject.getString(key);
                if (key.equals("displayStyleGroupId")) {
                    value = String.valueOf(serviceContext.getScopeGroupId());
                } else if (key.equals("rootLayoutUuid")) {
                    value = rootLayout == null ? "" : rootLayout.getUuid();
                }
                portletSetup.setValue(key, value);
            }
            portletSetup.store();
            long plid = 0L;
            if (Validator.isNotNull((String)layoutFriendlyURL) && (layout = this._layoutLocalService.fetchLayoutByFriendlyURL(serviceContext.getScopeGroupId(), false, layoutFriendlyURL)) != null) {
                plid = layout.getPlid();
            }
            if (plid > 0L) {
                this._setPlidPortletPreferences(plid, portletId, serviceContext);
            }
        }
    }

    private void _importSystemCommerceUserSegmentEntries(ServiceContext serviceContext) throws PortalException {
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Importing system commerce user segment entries...");
        }
        this._commerceUserSegmentEntryLocalService.importSystemCommerceUserSegmentEntries(serviceContext);
        if (_log.isInfoEnabled()) {
            _log.info((Object)"System commerce user segment entries successfully imported");
        }
    }

    private void _importThemePortletSettings(ServiceContext serviceContext) throws Exception {
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Importing theme portlet settings...");
        }
        JSONArray jsonArray = this._getJSONArray("theme-portlet-settings.json");
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            String portletName = jsonObject.getString("portletName");
            this._importSiteNavigationMenuPortletSettings(jsonObject, portletName, serviceContext);
        }
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Theme portlet settings successfully imported");
        }
    }

    private void _importThemeSettings(ServiceContext serviceContext) throws Exception {
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Importing theme settings...");
        }
        JSONObject themeSettingsJSONObject = this._getJSONObject("theme-settings.json");
        Iterator iterator = themeSettingsJSONObject.keys();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            String value = themeSettingsJSONObject.getString(key);
            this._updateThemeSetting(key, value, serviceContext);
        }
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Theme settings successfully imported");
        }
    }

    private void _initialize(long groupId) throws Exception {
        ServiceContext serviceContext = this._getServiceContext(groupId);
        this._importDefaultCommerceCountries(serviceContext);
        this._importDefaultCommerceCurrencies(serviceContext);
        this._importSystemCommerceUserSegmentEntries(serviceContext);
        this._importDefaultCPMeasurementUnits(serviceContext);
        this._updateThemeLookAndFeel(serviceContext);
        this._cleanLayouts(serviceContext);
        this._importLayouts(serviceContext);
        this._importAssetCategories(serviceContext);
        this._importCPOptionCategories(serviceContext);
        this._importCPOptions(serviceContext);
        this._importCPSpecificationOptions(serviceContext);
        List<CommerceWarehouse> commerceWarehouses = this._importCommerceWarehouses(serviceContext);
        this._importCPDefinitions(commerceWarehouses, serviceContext);
        this._importCPRules(serviceContext);
        this._importJournalArticles(serviceContext);
        this._importPortletSettings(serviceContext);
        this._importThemePortletSettings(serviceContext);
        this._importThemeSettings(serviceContext);
        this._updateLogo(serviceContext);
    }

    private void _setPlidPortletPreferences(long plid, String portletId, ServiceContext serviceContext) throws Exception {
        PortletPreferences portletSetup = PortletPreferencesFactoryUtil.getLayoutPortletSetup((long)serviceContext.getCompanyId(), (long)0L, (int)3, (long)plid, (String)portletId, (String)"");
        portletSetup.store();
    }

    private void _updateLogo(ServiceContext serviceContext) throws Exception {
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Updating logo...");
        }
        ClassLoader classLoader = BrecciaSiteInitializer.class.getClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream("com/liferay/commerce/initializer/breccia/internal/dependencies/images/Breccia-Logo.png");
        File file = FileUtil.createTempFile((InputStream)inputStream);
        this._cpFileImporter.updateLogo(file, false, true, serviceContext);
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Logo successfully updated");
        }
    }

    private void _updateThemeLookAndFeel(ServiceContext serviceContext) throws PortalException {
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Updating theme look and feel...");
        }
        this._cpFileImporter.updateLookAndFeel(_BRECCIA_THEME_ID, false, serviceContext);
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Theme look and feel successfully updated");
        }
    }

    private void _updateThemeSetting(String key, String value, ServiceContext serviceContext) {
        Theme theme = this._themeLocalService.fetchTheme(serviceContext.getCompanyId(), _BRECCIA_THEME_ID);
        if (theme == null) {
            return;
        }
        Map configurableSettings = theme.getConfigurableSettings();
        ThemeSetting themeSetting = (ThemeSetting)configurableSettings.get(key);
        themeSetting.setValue(value);
    }
}

