/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.commerce.discount.target;

import java.util.Locale;

/**
 * @author Marco Leo
 * @author Alessio Antonio Rendina
 */
public interface CommerceDiscountTarget {

	public String getKey();

	public String getLabel(Locale locale);

	public Type getType();

	public enum Type {

		APPLY_TO_PRODUCT("APPLY_TO_PRODUCT"),
		APPLY_TO_SHIPPING("APPLY_TO_SHIPPING"),
		APPLY_TO_SUBTOTAL("APPLY_TO_SUBTOTAL"),
		APPLY_TO_TOTAL("APPLY_TO_TOTAL");

		public String getValue() {
			return _value;
		}

		@Override
		public String toString() {
			return getValue();
		}

		private Type(final String value) {
			_value = value;
		}

		private final String _value;

	}

}