/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.commerce.discount.service.persistence;

import aQute.bnd.annotation.ProviderType;

/**
 * @author Marco Leo
 * @generated
 */
@ProviderType
public interface CommerceDiscountFinder {

	public int countByCommercePricingClassId(
		long commercePricingClassId, String title);

	public int countByCommercePricingClassId(
		long commercePricingClassId, String title, boolean inlineSQLHelper);

	public java.util.List<com.liferay.commerce.discount.model.CommerceDiscount>
		findByCommercePricingClassId(
			long commercePricingClassId, String title, int start, int end);

	public java.util.List<com.liferay.commerce.discount.model.CommerceDiscount>
		findByCommercePricingClassId(
			long commercePricingClassId, String title, int start, int end,
			boolean inlineSQLHelper);

	public java.util.List<com.liferay.commerce.discount.model.CommerceDiscount>
		findByUnqualifiedProduct(
			long companyId, long cpDefinitionId, long[] assetCategoryIds,
			long[] commercePricingClassIds);

	public java.util.List<com.liferay.commerce.discount.model.CommerceDiscount>
		findByUnqualifiedOrder(
			long companyId, String commerceDiscountTargetType);

	public java.util.List<com.liferay.commerce.discount.model.CommerceDiscount>
		findByA_C_C_Product(
			long commerceAccountId, long cpDefinitionId,
			long[] assetCategoryIds, long[] commercePricingClassIds);

	public java.util.List<com.liferay.commerce.discount.model.CommerceDiscount>
		findByA_C_C_Order(
			long commerceAccountId, String commerceDiscountTargetType);

	public java.util.List<com.liferay.commerce.discount.model.CommerceDiscount>
		findByAG_C_C_Product(
			long[] commerceAccountGroupIds, long cpDefinitionId,
			long[] assetCategoryIds, long[] commercePricingClassIds);

	public java.util.List<com.liferay.commerce.discount.model.CommerceDiscount>
		findByAG_C_C_Order(
			long[] commerceAccountGroupIds, String commerceDiscountTargetType);

	public java.util.List<com.liferay.commerce.discount.model.CommerceDiscount>
		findByC_C_C_Product(
			long commerceChannelId, long cpDefinitionId,
			long[] assetCategoryIds, long[] commercePricingClassIds);

	public java.util.List<com.liferay.commerce.discount.model.CommerceDiscount>
		findByC_C_C_Order(
			long commerceChannelId, String commerceDiscountTargetType);

	public java.util.List<com.liferay.commerce.discount.model.CommerceDiscount>
		findByA_C_C_C_Product(
			long commerceAccountId, long commerceChannelId, long cpDefinitionId,
			long[] assetCategoryIds, long[] commercePricingClassIds);

	public java.util.List<com.liferay.commerce.discount.model.CommerceDiscount>
		findByA_C_C_C_Order(
			long commerceAccountId, long commerceChannelId,
			String commerceDiscountTargetType);

	public java.util.List<com.liferay.commerce.discount.model.CommerceDiscount>
		findByAG_C_C_C_Product(
			long[] commerceAccountGroupIds, long commerceChannelId,
			long cpDefinitionId, long[] assetCategoryIds,
			long[] commercePricingClassIds);

	public java.util.List<com.liferay.commerce.discount.model.CommerceDiscount>
		findByAG_C_C_C_Order(
			long[] commerceAccountGroupIds, long commerceChannelId,
			String commerceDiscountTargetType);

	public java.util.List<com.liferay.commerce.discount.model.CommerceDiscount>
		findPriceListDiscountProduct(
			long[] commerceDiscountIds, long cpDefinitionId,
			long[] assetCategoryIds, long[] commercePricingClassIds);

}