/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.commerce.discount.model;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.service.ServiceContext;

import java.io.Serializable;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

/**
 * <p>
 * This class is a wrapper for {@link CommerceDiscountRule}.
 * </p>
 *
 * @author Marco Leo
 * @see CommerceDiscountRule
 * @generated
 */
public class CommerceDiscountRuleWrapper
	implements CommerceDiscountRule, ModelWrapper<CommerceDiscountRule> {

	public CommerceDiscountRuleWrapper(
		CommerceDiscountRule commerceDiscountRule) {

		_commerceDiscountRule = commerceDiscountRule;
	}

	@Override
	public Class<?> getModelClass() {
		return CommerceDiscountRule.class;
	}

	@Override
	public String getModelClassName() {
		return CommerceDiscountRule.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		attributes.put("commerceDiscountRuleId", getCommerceDiscountRuleId());
		attributes.put("companyId", getCompanyId());
		attributes.put("userId", getUserId());
		attributes.put("userName", getUserName());
		attributes.put("createDate", getCreateDate());
		attributes.put("modifiedDate", getModifiedDate());
		attributes.put("name", getName());
		attributes.put("commerceDiscountId", getCommerceDiscountId());
		attributes.put("type", getType());
		attributes.put("typeSettings", getTypeSettings());

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Long commerceDiscountRuleId = (Long)attributes.get(
			"commerceDiscountRuleId");

		if (commerceDiscountRuleId != null) {
			setCommerceDiscountRuleId(commerceDiscountRuleId);
		}

		Long companyId = (Long)attributes.get("companyId");

		if (companyId != null) {
			setCompanyId(companyId);
		}

		Long userId = (Long)attributes.get("userId");

		if (userId != null) {
			setUserId(userId);
		}

		String userName = (String)attributes.get("userName");

		if (userName != null) {
			setUserName(userName);
		}

		Date createDate = (Date)attributes.get("createDate");

		if (createDate != null) {
			setCreateDate(createDate);
		}

		Date modifiedDate = (Date)attributes.get("modifiedDate");

		if (modifiedDate != null) {
			setModifiedDate(modifiedDate);
		}

		String name = (String)attributes.get("name");

		if (name != null) {
			setName(name);
		}

		Long commerceDiscountId = (Long)attributes.get("commerceDiscountId");

		if (commerceDiscountId != null) {
			setCommerceDiscountId(commerceDiscountId);
		}

		String type = (String)attributes.get("type");

		if (type != null) {
			setType(type);
		}

		String typeSettings = (String)attributes.get("typeSettings");

		if (typeSettings != null) {
			setTypeSettings(typeSettings);
		}
	}

	@Override
	public Object clone() {
		return new CommerceDiscountRuleWrapper(
			(CommerceDiscountRule)_commerceDiscountRule.clone());
	}

	@Override
	public int compareTo(CommerceDiscountRule commerceDiscountRule) {
		return _commerceDiscountRule.compareTo(commerceDiscountRule);
	}

	/**
	 * Returns the commerce discount ID of this commerce discount rule.
	 *
	 * @return the commerce discount ID of this commerce discount rule
	 */
	@Override
	public long getCommerceDiscountId() {
		return _commerceDiscountRule.getCommerceDiscountId();
	}

	/**
	 * Returns the commerce discount rule ID of this commerce discount rule.
	 *
	 * @return the commerce discount rule ID of this commerce discount rule
	 */
	@Override
	public long getCommerceDiscountRuleId() {
		return _commerceDiscountRule.getCommerceDiscountRuleId();
	}

	/**
	 * Returns the company ID of this commerce discount rule.
	 *
	 * @return the company ID of this commerce discount rule
	 */
	@Override
	public long getCompanyId() {
		return _commerceDiscountRule.getCompanyId();
	}

	/**
	 * Returns the create date of this commerce discount rule.
	 *
	 * @return the create date of this commerce discount rule
	 */
	@Override
	public Date getCreateDate() {
		return _commerceDiscountRule.getCreateDate();
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return _commerceDiscountRule.getExpandoBridge();
	}

	/**
	 * Returns the modified date of this commerce discount rule.
	 *
	 * @return the modified date of this commerce discount rule
	 */
	@Override
	public Date getModifiedDate() {
		return _commerceDiscountRule.getModifiedDate();
	}

	/**
	 * Returns the name of this commerce discount rule.
	 *
	 * @return the name of this commerce discount rule
	 */
	@Override
	public String getName() {
		return _commerceDiscountRule.getName();
	}

	/**
	 * Returns the primary key of this commerce discount rule.
	 *
	 * @return the primary key of this commerce discount rule
	 */
	@Override
	public long getPrimaryKey() {
		return _commerceDiscountRule.getPrimaryKey();
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _commerceDiscountRule.getPrimaryKeyObj();
	}

	@Override
	public com.liferay.portal.kernel.util.UnicodeProperties
		getSettingsProperties() {

		return _commerceDiscountRule.getSettingsProperties();
	}

	@Override
	public String getSettingsProperty(String key) {
		return _commerceDiscountRule.getSettingsProperty(key);
	}

	/**
	 * Returns the type of this commerce discount rule.
	 *
	 * @return the type of this commerce discount rule
	 */
	@Override
	public String getType() {
		return _commerceDiscountRule.getType();
	}

	/**
	 * Returns the type settings of this commerce discount rule.
	 *
	 * @return the type settings of this commerce discount rule
	 */
	@Override
	public String getTypeSettings() {
		return _commerceDiscountRule.getTypeSettings();
	}

	/**
	 * Returns the user ID of this commerce discount rule.
	 *
	 * @return the user ID of this commerce discount rule
	 */
	@Override
	public long getUserId() {
		return _commerceDiscountRule.getUserId();
	}

	/**
	 * Returns the user name of this commerce discount rule.
	 *
	 * @return the user name of this commerce discount rule
	 */
	@Override
	public String getUserName() {
		return _commerceDiscountRule.getUserName();
	}

	/**
	 * Returns the user uuid of this commerce discount rule.
	 *
	 * @return the user uuid of this commerce discount rule
	 */
	@Override
	public String getUserUuid() {
		return _commerceDiscountRule.getUserUuid();
	}

	@Override
	public int hashCode() {
		return _commerceDiscountRule.hashCode();
	}

	@Override
	public boolean isCachedModel() {
		return _commerceDiscountRule.isCachedModel();
	}

	@Override
	public boolean isEscapedModel() {
		return _commerceDiscountRule.isEscapedModel();
	}

	@Override
	public boolean isNew() {
		return _commerceDiscountRule.isNew();
	}

	@Override
	public void persist() {
		_commerceDiscountRule.persist();
	}

	@Override
	public void setCachedModel(boolean cachedModel) {
		_commerceDiscountRule.setCachedModel(cachedModel);
	}

	/**
	 * Sets the commerce discount ID of this commerce discount rule.
	 *
	 * @param commerceDiscountId the commerce discount ID of this commerce discount rule
	 */
	@Override
	public void setCommerceDiscountId(long commerceDiscountId) {
		_commerceDiscountRule.setCommerceDiscountId(commerceDiscountId);
	}

	/**
	 * Sets the commerce discount rule ID of this commerce discount rule.
	 *
	 * @param commerceDiscountRuleId the commerce discount rule ID of this commerce discount rule
	 */
	@Override
	public void setCommerceDiscountRuleId(long commerceDiscountRuleId) {
		_commerceDiscountRule.setCommerceDiscountRuleId(commerceDiscountRuleId);
	}

	/**
	 * Sets the company ID of this commerce discount rule.
	 *
	 * @param companyId the company ID of this commerce discount rule
	 */
	@Override
	public void setCompanyId(long companyId) {
		_commerceDiscountRule.setCompanyId(companyId);
	}

	/**
	 * Sets the create date of this commerce discount rule.
	 *
	 * @param createDate the create date of this commerce discount rule
	 */
	@Override
	public void setCreateDate(Date createDate) {
		_commerceDiscountRule.setCreateDate(createDate);
	}

	@Override
	public void setExpandoBridgeAttributes(
		com.liferay.portal.kernel.model.BaseModel<?> baseModel) {

		_commerceDiscountRule.setExpandoBridgeAttributes(baseModel);
	}

	@Override
	public void setExpandoBridgeAttributes(ExpandoBridge expandoBridge) {
		_commerceDiscountRule.setExpandoBridgeAttributes(expandoBridge);
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		_commerceDiscountRule.setExpandoBridgeAttributes(serviceContext);
	}

	/**
	 * Sets the modified date of this commerce discount rule.
	 *
	 * @param modifiedDate the modified date of this commerce discount rule
	 */
	@Override
	public void setModifiedDate(Date modifiedDate) {
		_commerceDiscountRule.setModifiedDate(modifiedDate);
	}

	/**
	 * Sets the name of this commerce discount rule.
	 *
	 * @param name the name of this commerce discount rule
	 */
	@Override
	public void setName(String name) {
		_commerceDiscountRule.setName(name);
	}

	@Override
	public void setNew(boolean n) {
		_commerceDiscountRule.setNew(n);
	}

	/**
	 * Sets the primary key of this commerce discount rule.
	 *
	 * @param primaryKey the primary key of this commerce discount rule
	 */
	@Override
	public void setPrimaryKey(long primaryKey) {
		_commerceDiscountRule.setPrimaryKey(primaryKey);
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		_commerceDiscountRule.setPrimaryKeyObj(primaryKeyObj);
	}

	@Override
	public void setSettingsProperties(
		com.liferay.portal.kernel.util.UnicodeProperties settingsProperties) {

		_commerceDiscountRule.setSettingsProperties(settingsProperties);
	}

	/**
	 * Sets the type of this commerce discount rule.
	 *
	 * @param type the type of this commerce discount rule
	 */
	@Override
	public void setType(String type) {
		_commerceDiscountRule.setType(type);
	}

	/**
	 * Sets the type settings of this commerce discount rule.
	 *
	 * @param typeSettings the type settings of this commerce discount rule
	 */
	@Override
	public void setTypeSettings(String typeSettings) {
		_commerceDiscountRule.setTypeSettings(typeSettings);
	}

	/**
	 * Sets the user ID of this commerce discount rule.
	 *
	 * @param userId the user ID of this commerce discount rule
	 */
	@Override
	public void setUserId(long userId) {
		_commerceDiscountRule.setUserId(userId);
	}

	/**
	 * Sets the user name of this commerce discount rule.
	 *
	 * @param userName the user name of this commerce discount rule
	 */
	@Override
	public void setUserName(String userName) {
		_commerceDiscountRule.setUserName(userName);
	}

	/**
	 * Sets the user uuid of this commerce discount rule.
	 *
	 * @param userUuid the user uuid of this commerce discount rule
	 */
	@Override
	public void setUserUuid(String userUuid) {
		_commerceDiscountRule.setUserUuid(userUuid);
	}

	@Override
	public com.liferay.portal.kernel.model.CacheModel<CommerceDiscountRule>
		toCacheModel() {

		return _commerceDiscountRule.toCacheModel();
	}

	@Override
	public CommerceDiscountRule toEscapedModel() {
		return new CommerceDiscountRuleWrapper(
			_commerceDiscountRule.toEscapedModel());
	}

	@Override
	public String toString() {
		return _commerceDiscountRule.toString();
	}

	@Override
	public CommerceDiscountRule toUnescapedModel() {
		return new CommerceDiscountRuleWrapper(
			_commerceDiscountRule.toUnescapedModel());
	}

	@Override
	public String toXmlString() {
		return _commerceDiscountRule.toXmlString();
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof CommerceDiscountRuleWrapper)) {
			return false;
		}

		CommerceDiscountRuleWrapper commerceDiscountRuleWrapper =
			(CommerceDiscountRuleWrapper)object;

		if (Objects.equals(
				_commerceDiscountRule,
				commerceDiscountRuleWrapper._commerceDiscountRule)) {

			return true;
		}

		return false;
	}

	@Override
	public CommerceDiscountRule getWrappedModel() {
		return _commerceDiscountRule;
	}

	@Override
	public boolean isEntityCacheEnabled() {
		return _commerceDiscountRule.isEntityCacheEnabled();
	}

	@Override
	public boolean isFinderCacheEnabled() {
		return _commerceDiscountRule.isFinderCacheEnabled();
	}

	@Override
	public void resetOriginalValues() {
		_commerceDiscountRule.resetOriginalValues();
	}

	private final CommerceDiscountRule _commerceDiscountRule;

}