/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.commerce.discount.model;

import aQute.bnd.annotation.ProviderType;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.model.ShardedModel;
import com.liferay.portal.kernel.service.ServiceContext;

import java.io.Serializable;

import java.util.Date;

/**
 * The base model interface for the CommerceDiscountUserSegmentRel service. Represents a row in the &quot;CommerceDiscountUserSegmentRel&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation <code>com.liferay.commerce.discount.model.impl.CommerceDiscountUserSegmentRelModelImpl</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in <code>com.liferay.commerce.discount.model.impl.CommerceDiscountUserSegmentRelImpl</code>.
 * </p>
 *
 * @author Marco Leo
 * @see CommerceDiscountUserSegmentRel
 * @generated
 */
@ProviderType
public interface CommerceDiscountUserSegmentRelModel
	extends BaseModel<CommerceDiscountUserSegmentRel>, GroupedModel,
			ShardedModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this interface directly. All methods that expect a commerce discount user segment rel model instance should use the {@link CommerceDiscountUserSegmentRel} interface instead.
	 */

	/**
	 * Returns the primary key of this commerce discount user segment rel.
	 *
	 * @return the primary key of this commerce discount user segment rel
	 */
	public long getPrimaryKey();

	/**
	 * Sets the primary key of this commerce discount user segment rel.
	 *
	 * @param primaryKey the primary key of this commerce discount user segment rel
	 */
	public void setPrimaryKey(long primaryKey);

	/**
	 * Returns the commerce discount user segment rel ID of this commerce discount user segment rel.
	 *
	 * @return the commerce discount user segment rel ID of this commerce discount user segment rel
	 */
	public long getCommerceDiscountUserSegmentRelId();

	/**
	 * Sets the commerce discount user segment rel ID of this commerce discount user segment rel.
	 *
	 * @param commerceDiscountUserSegmentRelId the commerce discount user segment rel ID of this commerce discount user segment rel
	 */
	public void setCommerceDiscountUserSegmentRelId(
		long commerceDiscountUserSegmentRelId);

	/**
	 * Returns the group ID of this commerce discount user segment rel.
	 *
	 * @return the group ID of this commerce discount user segment rel
	 */
	@Override
	public long getGroupId();

	/**
	 * Sets the group ID of this commerce discount user segment rel.
	 *
	 * @param groupId the group ID of this commerce discount user segment rel
	 */
	@Override
	public void setGroupId(long groupId);

	/**
	 * Returns the company ID of this commerce discount user segment rel.
	 *
	 * @return the company ID of this commerce discount user segment rel
	 */
	@Override
	public long getCompanyId();

	/**
	 * Sets the company ID of this commerce discount user segment rel.
	 *
	 * @param companyId the company ID of this commerce discount user segment rel
	 */
	@Override
	public void setCompanyId(long companyId);

	/**
	 * Returns the user ID of this commerce discount user segment rel.
	 *
	 * @return the user ID of this commerce discount user segment rel
	 */
	@Override
	public long getUserId();

	/**
	 * Sets the user ID of this commerce discount user segment rel.
	 *
	 * @param userId the user ID of this commerce discount user segment rel
	 */
	@Override
	public void setUserId(long userId);

	/**
	 * Returns the user uuid of this commerce discount user segment rel.
	 *
	 * @return the user uuid of this commerce discount user segment rel
	 */
	@Override
	public String getUserUuid();

	/**
	 * Sets the user uuid of this commerce discount user segment rel.
	 *
	 * @param userUuid the user uuid of this commerce discount user segment rel
	 */
	@Override
	public void setUserUuid(String userUuid);

	/**
	 * Returns the user name of this commerce discount user segment rel.
	 *
	 * @return the user name of this commerce discount user segment rel
	 */
	@AutoEscape
	@Override
	public String getUserName();

	/**
	 * Sets the user name of this commerce discount user segment rel.
	 *
	 * @param userName the user name of this commerce discount user segment rel
	 */
	@Override
	public void setUserName(String userName);

	/**
	 * Returns the create date of this commerce discount user segment rel.
	 *
	 * @return the create date of this commerce discount user segment rel
	 */
	@Override
	public Date getCreateDate();

	/**
	 * Sets the create date of this commerce discount user segment rel.
	 *
	 * @param createDate the create date of this commerce discount user segment rel
	 */
	@Override
	public void setCreateDate(Date createDate);

	/**
	 * Returns the modified date of this commerce discount user segment rel.
	 *
	 * @return the modified date of this commerce discount user segment rel
	 */
	@Override
	public Date getModifiedDate();

	/**
	 * Sets the modified date of this commerce discount user segment rel.
	 *
	 * @param modifiedDate the modified date of this commerce discount user segment rel
	 */
	@Override
	public void setModifiedDate(Date modifiedDate);

	/**
	 * Returns the commerce discount ID of this commerce discount user segment rel.
	 *
	 * @return the commerce discount ID of this commerce discount user segment rel
	 */
	public long getCommerceDiscountId();

	/**
	 * Sets the commerce discount ID of this commerce discount user segment rel.
	 *
	 * @param commerceDiscountId the commerce discount ID of this commerce discount user segment rel
	 */
	public void setCommerceDiscountId(long commerceDiscountId);

	/**
	 * Returns the commerce user segment entry ID of this commerce discount user segment rel.
	 *
	 * @return the commerce user segment entry ID of this commerce discount user segment rel
	 */
	public long getCommerceUserSegmentEntryId();

	/**
	 * Sets the commerce user segment entry ID of this commerce discount user segment rel.
	 *
	 * @param commerceUserSegmentEntryId the commerce user segment entry ID of this commerce discount user segment rel
	 */
	public void setCommerceUserSegmentEntryId(long commerceUserSegmentEntryId);

	@Override
	public boolean isNew();

	@Override
	public void setNew(boolean n);

	@Override
	public boolean isCachedModel();

	@Override
	public void setCachedModel(boolean cachedModel);

	@Override
	public boolean isEscapedModel();

	@Override
	public Serializable getPrimaryKeyObj();

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj);

	@Override
	public ExpandoBridge getExpandoBridge();

	@Override
	public void setExpandoBridgeAttributes(BaseModel<?> baseModel);

	@Override
	public void setExpandoBridgeAttributes(ExpandoBridge expandoBridge);

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext);

	@Override
	public Object clone();

	@Override
	public int compareTo(
		CommerceDiscountUserSegmentRel commerceDiscountUserSegmentRel);

	@Override
	public int hashCode();

	@Override
	public CacheModel<CommerceDiscountUserSegmentRel> toCacheModel();

	@Override
	public CommerceDiscountUserSegmentRel toEscapedModel();

	@Override
	public CommerceDiscountUserSegmentRel toUnescapedModel();

	@Override
	public String toString();

	@Override
	public String toXmlString();

}