/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.commerce.discount.model;

import com.liferay.portal.kernel.annotation.ImplementationClassName;
import com.liferay.portal.kernel.model.PersistedModel;
import com.liferay.portal.kernel.util.Accessor;

import org.osgi.annotation.versioning.ProviderType;

/**
 * The extended model interface for the CommerceDiscountOrderTypeRel service. Represents a row in the &quot;CommerceDiscountOrderTypeRel&quot; database table, with each column mapped to a property of this class.
 *
 * @author Marco Leo
 * @see CommerceDiscountOrderTypeRelModel
 * @generated
 */
@ImplementationClassName(
	"com.liferay.commerce.discount.model.impl.CommerceDiscountOrderTypeRelImpl"
)
@ProviderType
public interface CommerceDiscountOrderTypeRel
	extends CommerceDiscountOrderTypeRelModel, PersistedModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify this interface directly. Add methods to <code>com.liferay.commerce.discount.model.impl.CommerceDiscountOrderTypeRelImpl</code> and rerun ServiceBuilder to automatically copy the method declarations to this interface.
	 */
	public static final Accessor<CommerceDiscountOrderTypeRel, Long>
		COMMERCE_DISCOUNT_ORDER_TYPE_REL_ID_ACCESSOR =
			new Accessor<CommerceDiscountOrderTypeRel, Long>() {

				@Override
				public Long get(
					CommerceDiscountOrderTypeRel commerceDiscountOrderTypeRel) {

					return commerceDiscountOrderTypeRel.
						getCommerceDiscountOrderTypeRelId();
				}

				@Override
				public Class<Long> getAttributeClass() {
					return Long.class;
				}

				@Override
				public Class<CommerceDiscountOrderTypeRel> getTypeClass() {
					return CommerceDiscountOrderTypeRel.class;
				}

			};

	public CommerceDiscount getCommerceDiscount()
		throws com.liferay.portal.kernel.exception.PortalException;

}