/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.commerce.discount.service.persistence;

import org.osgi.annotation.versioning.ProviderType;

/**
 * @author Marco Leo
 * @generated
 */
@ProviderType
public interface CommerceDiscountRelFinder {

	public int countCategoriesByCommerceDiscountId(
		long commerceDiscountId, String name);

	public int countCategoriesByCommerceDiscountId(
		long commerceDiscountId, String name, boolean inlineSQLHelper);

	public int countCPDefinitionsByCommerceDiscountId(
		long commerceDiscountId, String name, String languageId);

	public int countCPDefinitionsByCommerceDiscountId(
		long commerceDiscountId, String name, String languageId,
		boolean inlineSQLHelper);

	public int countPricingClassesByCommerceDiscountId(
		long commerceDiscountId, String title);

	public int countPricingClassesByCommerceDiscountId(
		long commerceDiscountId, String title, boolean inlineSQLHelper);

	public java.util.List
		<com.liferay.commerce.discount.model.CommerceDiscountRel>
			findCategoriesByCommerceDiscountId(
				long commerceDiscountId, String name, int start, int end);

	public java.util.List
		<com.liferay.commerce.discount.model.CommerceDiscountRel>
			findCategoriesByCommerceDiscountId(
				long commerceDiscountId, String name, int start, int end,
				boolean inlineSQLHelper);

	public java.util.List
		<com.liferay.commerce.discount.model.CommerceDiscountRel>
			findCPDefinitionsByCommerceDiscountId(
				long commerceDiscountId, String name, String languageId,
				int start, int end);

	public java.util.List
		<com.liferay.commerce.discount.model.CommerceDiscountRel>
			findCPDefinitionsByCommerceDiscountId(
				long commerceDiscountId, String name, String languageId,
				int start, int end, boolean inlineSQLHelper);

	public java.util.List
		<com.liferay.commerce.discount.model.CommerceDiscountRel>
			findPricingClassesByCommerceDiscountId(
				long commerceDiscountId, String title, int start, int end);

	public java.util.List
		<com.liferay.commerce.discount.model.CommerceDiscountRel>
			findPricingClassesByCommerceDiscountId(
				long commerceDiscountId, String title, int start, int end,
				boolean inlineSQLHelper);

}