/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.commerce.discount.validator;

import com.liferay.petra.string.StringPool;
import com.liferay.portal.kernel.util.Validator;

import java.io.Serializable;

/**
 * @author Riccardo Alberti
 */
public class CommerceDiscountValidatorResult implements Serializable {

	public CommerceDiscountValidatorResult(boolean valid) {
		this(0, valid, StringPool.BLANK);
	}

	public CommerceDiscountValidatorResult(boolean valid, String message) {
		this(0, valid, message);
	}

	public CommerceDiscountValidatorResult(
		long commerceDiscountId, boolean valid, String message) {

		_commerceDiscountId = commerceDiscountId;
		_valid = valid;
		_message = message;
	}

	public long getCommerceDiscountId() {
		return _commerceDiscountId;
	}

	public String getMessage() {
		return _message;
	}

	public boolean hasMessageResult() {
		if (Validator.isNotNull(getMessage())) {
			return true;
		}

		return false;
	}

	public boolean isValid() {
		return _valid;
	}

	private long _commerceDiscountId;
	private String _message;
	private boolean _valid;

}