/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.data.integration.internal.process.type;

import com.liferay.commerce.data.integration.internal.process.type.comparator.ProcessTypeOrderComparator;
import com.liferay.commerce.data.integration.process.type.ProcessType;
import com.liferay.commerce.data.integration.process.type.ProcessTypeRegistry;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerCustomizerFactory;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ListUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Component(immediate=true, service={ProcessTypeRegistry.class})
public class ProcessTypeRegistryImpl
implements ProcessTypeRegistry {
    private static final Log _log = LogFactoryUtil.getLog(ProcessTypeRegistryImpl.class);
    private final Comparator<ServiceTrackerCustomizerFactory.ServiceWrapper<ProcessType>> _processTypeServiceWrapperOrderComparator = new ProcessTypeOrderComparator();
    private ServiceTrackerMap<String, ServiceTrackerCustomizerFactory.ServiceWrapper<ProcessType>> _serviceTrackerMap;

    public ProcessType getProcessType(String key) {
        ServiceTrackerCustomizerFactory.ServiceWrapper processTypeServiceWrapper = (ServiceTrackerCustomizerFactory.ServiceWrapper)this._serviceTrackerMap.getService((Object)key);
        if (processTypeServiceWrapper == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("No ProcessType registered with key " + key));
            }
            return null;
        }
        return (ProcessType)processTypeServiceWrapper.getService();
    }

    public List<ProcessType> getProcessTypes() {
        ArrayList<Object> processTypes = new ArrayList<Object>();
        List processTypeServiceWrappers = ListUtil.fromCollection((Collection)this._serviceTrackerMap.values());
        Collections.sort(processTypeServiceWrappers, this._processTypeServiceWrapperOrderComparator);
        for (ServiceTrackerCustomizerFactory.ServiceWrapper processTypeServiceWrapper : processTypeServiceWrappers) {
            processTypes.add(processTypeServiceWrapper.getService());
        }
        return Collections.unmodifiableList(processTypes);
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._serviceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, ProcessType.class, (String)"commerce.data.integration.process.type.key", (ServiceTrackerCustomizer)ServiceTrackerCustomizerFactory.serviceWrapper((BundleContext)bundleContext));
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTrackerMap.close();
    }
}

