/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.data.integration.internal.permission;

import com.liferay.commerce.data.integration.model.CommerceDataIntegrationProcess;
import com.liferay.commerce.data.integration.permission.CommerceDataIntegrationProcessPermission;
import com.liferay.commerce.data.integration.service.CommerceDataIntegrationProcessLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={CommerceDataIntegrationProcessPermission.class})
public class CommerceDataIntegrationProcessPermissionImpl
implements CommerceDataIntegrationProcessPermission {
    @Reference
    private CommerceDataIntegrationProcessLocalService _commerceDataIntegrationProcessLocalService;

    public void check(PermissionChecker permissionChecker, CommerceDataIntegrationProcess commerceDataIntegrationProcess, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, commerceDataIntegrationProcess, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, CommerceDataIntegrationProcess.class.getName(), commerceDataIntegrationProcess.getCommerceDataIntegrationProcessId(), new String[]{actionId});
        }
    }

    public void check(PermissionChecker permissionChecker, long commerceDataIntegrationProcessId, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, commerceDataIntegrationProcessId, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, CommerceDataIntegrationProcess.class.getName(), commerceDataIntegrationProcessId, new String[]{actionId});
        }
    }

    public boolean contains(PermissionChecker permissionChecker, CommerceDataIntegrationProcess commerceDataIntegrationProcess, String actionId) throws PortalException {
        return this.contains(permissionChecker, commerceDataIntegrationProcess.getCommerceDataIntegrationProcessId(), actionId);
    }

    public boolean contains(PermissionChecker permissionChecker, long commerceDataIntegrationProcessId, String actionId) throws PortalException {
        CommerceDataIntegrationProcess commerceDataIntegrationProcess = this._commerceDataIntegrationProcessLocalService.fetchCommerceDataIntegrationProcess(commerceDataIntegrationProcessId);
        if (commerceDataIntegrationProcess == null) {
            return false;
        }
        return this._contains(permissionChecker, commerceDataIntegrationProcess, actionId);
    }

    private boolean _contains(PermissionChecker permissionChecker, CommerceDataIntegrationProcess commerceDataIntegrationProcess, String actionId) throws PortalException {
        if (permissionChecker.hasOwnerPermission(commerceDataIntegrationProcess.getCompanyId(), CommerceDataIntegrationProcess.class.getName(), commerceDataIntegrationProcess.getCommerceDataIntegrationProcessId(), commerceDataIntegrationProcess.getUserId(), actionId)) {
            return true;
        }
        return permissionChecker.hasPermission(0L, CommerceDataIntegrationProcess.class.getName(), commerceDataIntegrationProcess.getCommerceDataIntegrationProcessId(), actionId);
    }
}

