/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.commerce.data.integration.model.impl;

import com.liferay.commerce.data.integration.model.CommerceDataIntegrationProcessLog;
import com.liferay.commerce.data.integration.service.CommerceDataIntegrationProcessLogLocalServiceUtil;

/**
 * The extended model base implementation for the CommerceDataIntegrationProcessLog service. Represents a row in the &quot;CDataIntegrationProcessLog&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link CommerceDataIntegrationProcessLogImpl}.
 * </p>
 *
 * @author Alessio Antonio Rendina
 * @see CommerceDataIntegrationProcessLogImpl
 * @see CommerceDataIntegrationProcessLog
 * @generated
 */
public abstract class CommerceDataIntegrationProcessLogBaseImpl
	extends CommerceDataIntegrationProcessLogModelImpl
	implements CommerceDataIntegrationProcessLog {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a commerce data integration process log model instance should use the <code>CommerceDataIntegrationProcessLog</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			CommerceDataIntegrationProcessLogLocalServiceUtil.
				addCommerceDataIntegrationProcessLog(this);
		}
		else {
			CommerceDataIntegrationProcessLogLocalServiceUtil.
				updateCommerceDataIntegrationProcessLog(this);
		}
	}

}