/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.data.integration.internal.trigger;

import com.liferay.commerce.data.integration.trigger.CommerceDataIntegrationProcessTriggerHelper;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.scheduler.SchedulerEngineHelper;
import com.liferay.portal.kernel.scheduler.SchedulerException;
import com.liferay.portal.kernel.scheduler.StorageType;
import com.liferay.portal.kernel.scheduler.Trigger;
import com.liferay.portal.kernel.scheduler.TriggerFactory;
import com.liferay.portal.kernel.scheduler.messaging.SchedulerResponse;
import java.util.Date;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={CommerceDataIntegrationProcessTriggerHelper.class})
public class CommerceDataIntegrationProcessTriggerHelperImpl
implements CommerceDataIntegrationProcessTriggerHelper {
    public static final String JOB_NAME_PREFIX_X = "COMMERCE_DATA_INTEGRATION_PROCESS_%s";
    private static final Log _log = LogFactoryUtil.getLog(CommerceDataIntegrationProcessTriggerHelperImpl.class);
    @Reference
    private SchedulerEngineHelper _schedulerEngineHelper;
    @Reference
    private TriggerFactory _triggerFactory;

    public void addScheduledTask(long commerceDataIntegrationProcessId, String cronExpression, Date startDate, Date endDate) throws SchedulerException {
        this.deleteScheduledTask(commerceDataIntegrationProcessId);
        Trigger trigger = this._triggerFactory.createTrigger(String.valueOf(commerceDataIntegrationProcessId), this._getGroupName(commerceDataIntegrationProcessId), startDate, endDate, cronExpression);
        JSONObject payLoad = JSONUtil.put((String)"commerceDataIntegrationProcessId", (Object)commerceDataIntegrationProcessId);
        this._schedulerEngineHelper.schedule(trigger, StorageType.PERSISTED, null, "liferay/commerce/data_integration/executor", (Object)payLoad.toString(), 1000);
    }

    public void deleteScheduledTask(long commerceDataIntegrationProcessId) throws SchedulerException {
        SchedulerResponse scheduledJob = this.getScheduledJob(commerceDataIntegrationProcessId);
        if (scheduledJob != null) {
            this._schedulerEngineHelper.delete(String.valueOf(commerceDataIntegrationProcessId), this._getGroupName(commerceDataIntegrationProcessId), StorageType.PERSISTED);
        }
    }

    public Date getNextFireTime(long commerceDataIntegrationProcessId) {
        Date nextFireTime = null;
        try {
            nextFireTime = this._schedulerEngineHelper.getNextFireTime(String.valueOf(commerceDataIntegrationProcessId), this._getGroupName(commerceDataIntegrationProcessId), StorageType.PERSISTED);
        }
        catch (SchedulerException se) {
            _log.error((Object)se, (Throwable)se);
        }
        return nextFireTime;
    }

    public Date getPreviousFireTime(long commerceDataIntegrationProcessId) {
        Date nextFireTime = null;
        try {
            nextFireTime = this._schedulerEngineHelper.getPreviousFireTime(String.valueOf(commerceDataIntegrationProcessId), this._getGroupName(commerceDataIntegrationProcessId), StorageType.PERSISTED);
        }
        catch (SchedulerException se) {
            _log.error((Object)se, (Throwable)se);
        }
        return nextFireTime;
    }

    public SchedulerResponse getScheduledJob(long commerceDataIntegrationProcessId) throws SchedulerException {
        return this._schedulerEngineHelper.getScheduledJob(String.valueOf(commerceDataIntegrationProcessId), this._getGroupName(commerceDataIntegrationProcessId), StorageType.PERSISTED);
    }

    private String _getGroupName(long commerceDataIntegrationProcessId) {
        return String.format(JOB_NAME_PREFIX_X, commerceDataIntegrationProcessId);
    }
}

