var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __reExport = (target, mod, secondTarget) => (__copyProps(target, mod, "default"), secondTarget && __copyProps(secondTarget, mod, "default"));

// ../../../../../../../../../../$/bridge/for/main/react
var react_exports = {};
__export(react_exports, {
  default: () => react_default
});
__reExport(react_exports, react_star);
import * as react_star from "../../frontend-js-react-web/__liferay__/exports/react.js";
import __default__ from "../../frontend-js-react-web/__liferay__/exports/react.js";
var react_default = __default__;

// ../../../../../../../../../../$/bridge/for/main/@clayui/charts
var charts_exports = {};
__export(charts_exports, {
  default: () => charts_default
});
__reExport(charts_exports, clayui_charts_star);
import * as clayui_charts_star from "../../frontend-taglib-clay/__liferay__/exports/@clayui$charts.js";
import __default__2 from "../../frontend-taglib-clay/__liferay__/exports/@clayui$charts.js";
var charts_default = __default__2;

// src/main/resources/META-INF/resources/js/ChartWrapper.js
function ChartWrapper({ data, loading }) {
  const chartRef = (0, react_exports.useRef)();
  const resize = (0, react_exports.useCallback)(
    () => chartRef.current && chartRef.current.resize(),
    [chartRef]
  );
  const wrapper = (0, react_exports.useCallback)(
    (node) => {
      if (node !== null) {
        new ResizeObserver(resize).observe(node);
      }
    },
    [resize]
  );
  if (loading) {
    return /* @__PURE__ */ react_default.createElement("span", { "aria-hidden": "true", className: "loading-animation" });
  } else if (!data.data.columns.length) {
    return /* @__PURE__ */ react_default.createElement("p", null, Liferay.Language.get("no-data-available"));
  } else {
    return /* @__PURE__ */ react_default.createElement("div", { ref: wrapper }, /* @__PURE__ */ react_default.createElement(charts_default, { ...data, ref: chartRef }));
  }
}

// ../../../../../../../../../../$/bridge/for/main/frontend-js-web
var frontend_js_web_exports = {};
__reExport(frontend_js_web_exports, liferay_star);
import * as liferay_star from "../../frontend-js-web/__liferay__/index.js";

// src/main/resources/META-INF/resources/js/utils/loadData.es.js
var NULL_VALUE = 14e-46;
var headers = {
  "Content-Type": "application/json"
};
function byDate(a, b) {
  return new Date(a.timestamp) - new Date(b.timestamp);
}
function byName(a, b) {
  return a.name.localeCompare(b.name);
}
function formatCategoriesForChart(categories) {
  return categories.reduce(
    (a, c) => Object.assign(a, { [`${c.id}`]: c.name }),
    {}
  );
}
function formatDataForChart(points = []) {
  const categories = getCategoriesArray(points);
  return {
    axis: {
      x: {
        type: "timeseries"
      }
    },
    data: {
      columns: formatPointsForChart(points, categories),
      names: formatCategoriesForChart(categories),
      type: "predictive",
      types: getLineTypesForChart(categories),
      x: "x"
    },
    predictionDate: getPredictionDate(points)
  };
}
function formatPointForForecast(point) {
  return point.actual !== NULL_VALUE ? point.actual : {
    high: point.forecastUpperBound,
    low: point.forecastLowerBound,
    mid: point.forecast
  };
}
function formatPointsForChart(points, categories) {
  return !points.length ? [] : [
    ["x", ...getDates(points)],
    ...categories.map((c) => [
      `${c.id}`,
      ...getValuesForCategory(points, c)
    ])
  ];
}
function getCategoriesArray(items = []) {
  return [
    ...items.reduce((a, c) => {
      a.set(c.category, c.categoryTitle);
      return a;
    }, /* @__PURE__ */ new Map()).entries()
  ].map(([id, name]) => ({
    id,
    name
  })).sort(byName);
}
function getDates(points) {
  return points.filter(isPartOfCategory(points[0].category)).map((d) => getDateString(d.timestamp));
}
function getDateString(ts) {
  return (ts || "").slice(0, 10);
}
function getLineTypesForChart(categories) {
  return categories.reduce(
    (a, c) => Object.assign(a, { [`${c.id}`]: "area-line-range" }),
    {}
  );
}
function getPoints({ items }) {
  return items;
}
function getPredictionDate(points) {
  return !points.length ? null : getDateString(
    points.slice().reverse().find((d) => d.actual !== NULL_VALUE).timestamp
  );
}
function hasNoActualNorForecastValue({ actual, forecast }) {
  return !(actual === NULL_VALUE && forecast === NULL_VALUE);
}
function getValuesForCategory(points, category) {
  return points.filter(isPartOfCategory(category.id)).filter(hasNoActualNorForecastValue).map(formatPointForForecast);
}
function isPartOfCategory(id) {
  return ({ category }) => category === id;
}
function loadData(url) {
  return parseData(
    (0, frontend_js_web_exports.fetch)(url, {
      headers
    }).then(responseToJson)
  );
}
function parseData(loadData2) {
  return loadData2.then(getPoints).then(sortPointsByDate).then(formatDataForChart);
}
function responseToJson(response) {
  return response.json();
}
function sortPointsByDate(points = []) {
  return points.sort(byDate);
}

// src/main/resources/META-INF/resources/js/ForecastChart.js
function ForecastChart({
  APIBaseUrl,
  accountIds: initialAccountsIds = [],
  categoryIds = []
}) {
  const [loading, setLoading] = (0, react_exports.useState)(true);
  const [chartData, setChartData] = (0, react_exports.useState)({});
  const [accountsId, setAccountId] = (0, react_exports.useState)(initialAccountsIds);
  Liferay.on("accountSelected", ({ accountId }) => setAccountId([accountId]));
  function updateData() {
    const formattedAccountIds = accountsId.map((id) => `accountIds=${id}`).join("&");
    const formattedCategoryIds = categoryIds.length ? "&" + categoryIds.map((id) => `categoryIds=${id}`).join("&") : "";
    const APIUrl = `${APIBaseUrl}?${formattedAccountIds}${formattedCategoryIds}&pageSize=200`;
    startLoading();
    loadData(APIUrl).then(setChartData);
  }
  function stopLoading() {
    setLoading(!chartData.data);
  }
  function startLoading() {
    setLoading(true);
  }
  (0, react_exports.useEffect)(updateData, [accountsId]);
  (0, react_exports.useEffect)(stopLoading, [chartData]);
  return !accountsId ? /* @__PURE__ */ react_default.createElement("p", null, Liferay.Language.get("no-account-selected")) : /* @__PURE__ */ react_default.createElement(ChartWrapper, { data: chartData, loading });
}

// src/main/resources/META-INF/resources/js/HistoryChart.js
function HistoryChart() {
  const chartData = {
    axis: {
      x: {
        categories: [
          "Jan",
          "Feb",
          "Mar",
          "Apr",
          "May",
          "Jun",
          "Jul",
          "Aug",
          "Sep"
        ],
        type: "category"
      }
    },
    color: {
      pattern: ["#4B9BFF"]
    },
    data: {
      columns: [
        ["2019", 30, 200, 100, 400, 150, 250, 50, 100, 250],
        ["2018", 100, 30, 200, 320, 50, 150, 230, 80, 150]
      ],
      order: null,
      type: "line"
    },
    grid: {
      x: {
        // lines: COLUMNS[0].map((c, i) => ({value: i}))
        show: false
      }
    },
    legend: {
      show: false
    },
    line: {
      classes: ["bb-line-past", "bb-line-present"]
    },
    point: {
      show: false
    }
  };
  return /* @__PURE__ */ react_default.createElement(
    ChartWrapper,
    {
      data: chartData,
      noDataErrorMessage: Liferay.Language.get("no-data-available")
    }
  );
}

// src/main/resources/META-INF/resources/js/OverviewChart.js
function OverviewChart() {
  return /* @__PURE__ */ react_default.createElement("div", { className: "overview-chart-wrapper" }, /* @__PURE__ */ react_default.createElement("div", { className: "donut", style: { "--perc": 66 } }, /* @__PURE__ */ react_default.createElement("div", { className: "chart" }, /* @__PURE__ */ react_default.createElement(
    "svg",
    {
      viewBox: "0 0 104 104",
      xmlns: "http://www.w3.org/2000/svg"
    },
    /* @__PURE__ */ react_default.createElement("circle", { className: "track", cx: "52", cy: "52", r: "50" }),
    /* @__PURE__ */ react_default.createElement("circle", { className: "filler", cx: "52", cy: "52", r: "50" })
  ), /* @__PURE__ */ react_default.createElement("div", { className: "text" }, "66%")), /* @__PURE__ */ react_default.createElement("div", { className: "label" }, "Label")), /* @__PURE__ */ react_default.createElement("div", { className: "donut", style: { "--perc": 66 } }, /* @__PURE__ */ react_default.createElement("div", { className: "chart" }, /* @__PURE__ */ react_default.createElement(
    "svg",
    {
      viewBox: "0 0 104 104",
      xmlns: "http://www.w3.org/2000/svg"
    },
    /* @__PURE__ */ react_default.createElement("circle", { className: "track", cx: "52", cy: "52", r: "50" }),
    /* @__PURE__ */ react_default.createElement("circle", { className: "filler", cx: "52", cy: "52", r: "50" })
  ), /* @__PURE__ */ react_default.createElement("div", { className: "text" }, "66%")), /* @__PURE__ */ react_default.createElement("div", { className: "label" }, "Label")), /* @__PURE__ */ react_default.createElement("div", { className: "donut", style: { "--perc": 66 } }, /* @__PURE__ */ react_default.createElement("div", { className: "chart" }, /* @__PURE__ */ react_default.createElement(
    "svg",
    {
      viewBox: "0 0 104 104",
      xmlns: "http://www.w3.org/2000/svg"
    },
    /* @__PURE__ */ react_default.createElement("circle", { className: "track", cx: "52", cy: "52", r: "50" }),
    /* @__PURE__ */ react_default.createElement("circle", { className: "filler", cx: "52", cy: "52", r: "50" })
  ), /* @__PURE__ */ react_default.createElement("div", { className: "text" }, "66%")), /* @__PURE__ */ react_default.createElement("div", { className: "label" }, "Label")));
}

// src/main/resources/META-INF/resources/js/StatusChart.js
function StatusChart() {
  const chartData = {
    axis: {
      x: {
        type: "category"
      },
      y: {
        tick: {
          count: 5
        }
      }
    },
    data: {
      columns: [
        ["x", "Draft", "Pending", "Approved", "Placed", "Delivered"],
        ["quantity", 8e4, 5e4, 6e4, 2e4, 35e3]
      ],
      type: "bar",
      x: "x"
    },
    grid: {
      x: {
        show: false
      }
    },
    legend: {
      show: false
    }
  };
  return /* @__PURE__ */ react_default.createElement(
    ChartWrapper,
    {
      data: chartData,
      noDataErrorMessage: Liferay.Language.get("no-data-available")
    }
  );
}
export {
  ForecastChart,
  HistoryChart,
  OverviewChart,
  StatusChart
};
//# sourceMappingURL=index.js.map
