import{NULL_VALUE,formatCategoriesForChart,formatPointForForecast,formatPointsForChart,getCategoriesArray,getDateString,getDates,getLineTypesForChart,getPoints,getPredictionDate,getValuesForCategory,hasNoActualNorForecastValue,isPartOfCategory,parseData}from"../loadData.es";import{input,output,simpleInput,simpleOutput}from"../mock/data";const categoriesSubset=getCategoriesArray(simpleInput.items),loadData=t=>new Promise((e=>e(t)));describe("Chart loadData utils",(()=>{it("Format categories for chart",(()=>{expect(formatCategoriesForChart(categoriesSubset)).toEqual({1:"Cat 1",2:"Cat 2"})})),it("Format point for forecast",(()=>{const t=simpleInput.items.find((t=>14e-46!==t.actual)),e=simpleInput.items.find((t=>14e-46===t.actual));expect(formatPointForForecast(t)).toBe(t.actual),expect(formatPointForForecast(e)).toEqual({high:e.forecastUpperBound,low:e.forecastLowerBound,mid:e.forecast})})),it("Format points for chart",(()=>{expect(formatPointsForChart(simpleInput.items,categoriesSubset)).toEqual([["x","2019-04-01","2019-05-01"],["1",15,{high:18,low:12,mid:16}],["2",25,{high:28,low:22,mid:26}]]),expect(formatPointsForChart([],[])).toEqual([])})),it("Get categories array",(()=>{expect(getCategoriesArray(simpleInput.items)).toEqual([{id:1,name:"Cat 1"},{id:2,name:"Cat 2"}])})),it("Get dates list",(()=>{expect(getDates(simpleInput.items)).toEqual(["2019-04-01","2019-05-01"])})),it("Convert date to string",(()=>{expect(getDateString("2019-07-01T00:00:00Z")).toBe("2019-07-01"),expect(getDateString("")).toBe(""),expect(getDateString(void 0)).toBe("")})),it("Get line types for chart",(()=>{expect(getLineTypesForChart(categoriesSubset)).toEqual({1:"area-line-range",2:"area-line-range"})})),it("Extract points from data object",(()=>{expect(getPoints(simpleInput)).toEqual(simpleInput.items)})),it("Find the prediction date",(()=>{expect(getPredictionDate(input.items)).toBe("2019-11-01"),expect(getPredictionDate(simpleInput.items)).toBe("2019-04-01")})),it("Get values for a category",(()=>{expect(getValuesForCategory(simpleInput.items,{id:1})).toEqual([15,{high:18,low:12,mid:16}])})),it("Is part of a category",(()=>{expect(isPartOfCategory(1)({category:1})).toBe(!0),expect(isPartOfCategory(1)({category:2})).toBe(!1),expect(isPartOfCategory(2)({category:1})).toBe(!1)})),it("Filters out points whose actual AND forecast values are NULL",(()=>{const t={actual:1232,forecast:NULL_VALUE},e=[{actual:NULL_VALUE,forecast:NULL_VALUE},t].filter(hasNoActualNorForecastValue);expect(e).toEqual([t])})),it("Parse data",(()=>parseData(loadData(input)).then((t=>{expect(t).toEqual(output)})))),it("Parse simple data",(()=>parseData(loadData(simpleInput)).then((t=>{expect(t).toEqual(simpleOutput)}))))}));
//# sourceMappingURL=loadData.js.map