Liferay.Loader.define("commerce-dashboard-web$d3-hierarchy@1.1.8/src/treemap/binary", ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    export default function (parent, x0, y0, x1, y1) {
      var nodes = parent.children,
          i,
          n = nodes.length,
          sum,
          sums = new Array(n + 1);

      for (sums[0] = sum = i = 0; i < n; ++i) {
        sums[i + 1] = sum += nodes[i].value;
      }

      partition(0, n, parent.value, x0, y0, x1, y1);

      function partition(i, j, value, x0, y0, x1, y1) {
        if (i >= j - 1) {
          var node = nodes[i];
          node.x0 = x0, node.y0 = y0;
          node.x1 = x1, node.y1 = y1;
          return;
        }

        var valueOffset = sums[i],
            valueTarget = value / 2 + valueOffset,
            k = i + 1,
            hi = j - 1;

        while (k < hi) {
          var mid = k + hi >>> 1;
          if (sums[mid] < valueTarget) k = mid + 1;else hi = mid;
        }

        if (valueTarget - sums[k - 1] < sums[k] - valueTarget && i + 1 < k) --k;

        var valueLeft = sums[k] - valueOffset,
            valueRight = value - valueLeft;

        if (x1 - x0 > y1 - y0) {
          var xk = (x0 * valueRight + x1 * valueLeft) / value;
          partition(i, k, valueLeft, x0, y0, xk, y1);
          partition(k, j, valueRight, xk, y0, x1, y1);
        } else {
          var yk = (y0 * valueRight + y1 * valueLeft) / value;
          partition(i, k, valueLeft, x0, y0, x1, yk);
          partition(k, j, valueRight, x0, yk, x1, y1);
        }
      }
    }
  }
});
//# sourceMappingURL=binary.js.map