Liferay.Loader.define('commerce-dashboard-web$d3-transition@1.2.0/dist/d3-transition', ['module', 'exports', 'require', 'commerce-dashboard-web$d3-dispatch', 'commerce-dashboard-web$d3-timer', 'commerce-dashboard-web$d3-color', 'commerce-dashboard-web$d3-interpolate', 'commerce-dashboard-web$d3-selection', 'commerce-dashboard-web$d3-ease'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    // https://d3js.org/d3-transition/ v1.2.0 Copyright 2019 Mike Bostock
    (function (global, factory) {
      typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('commerce-dashboard-web$d3-dispatch'), require('commerce-dashboard-web$d3-timer'), require('commerce-dashboard-web$d3-color'), require('commerce-dashboard-web$d3-interpolate'), require('commerce-dashboard-web$d3-selection'), require('commerce-dashboard-web$d3-ease')) : typeof define === 'function' && define.amd ? define(['exports', 'd3-dispatch', 'd3-timer', 'd3-color', 'd3-interpolate', 'd3-selection', 'd3-ease'], factory) : factory(global.d3 = global.d3 || {}, global.d3, global.d3, global.d3, global.d3, global.d3, global.d3);
    })(this, function (exports, d3Dispatch, d3Timer, d3Color, d3Interpolate, d3Selection, d3Ease) {
      'use strict';

      var emptyOn = d3Dispatch.dispatch("start", "end", "cancel", "interrupt");
      var emptyTween = [];

      var CREATED = 0;
      var SCHEDULED = 1;
      var STARTING = 2;
      var STARTED = 3;
      var RUNNING = 4;
      var ENDING = 5;
      var ENDED = 6;

      function schedule(node, name, id, index, group, timing) {
        var schedules = node.__transition;
        if (!schedules) node.__transition = {};else if (id in schedules) return;
        create(node, id, {
          name: name,
          index: index, // For context during callback.
          group: group, // For context during callback.
          on: emptyOn,
          tween: emptyTween,
          time: timing.time,
          delay: timing.delay,
          duration: timing.duration,
          ease: timing.ease,
          timer: null,
          state: CREATED
        });
      }

      function init(node, id) {
        var schedule = get(node, id);
        if (schedule.state > CREATED) throw new Error("too late; already scheduled");
        return schedule;
      }

      function set(node, id) {
        var schedule = get(node, id);
        if (schedule.state > STARTED) throw new Error("too late; already running");
        return schedule;
      }

      function get(node, id) {
        var schedule = node.__transition;
        if (!schedule || !(schedule = schedule[id])) throw new Error("transition not found");
        return schedule;
      }

      function create(node, id, self) {
        var schedules = node.__transition,
            tween;

        // Initialize the self timer when the transition is created.
        // Note the actual delay is not known until the first callback!
        schedules[id] = self;
        self.timer = d3Timer.timer(function schedule(elapsed) {
          self.state = SCHEDULED;
          self.timer.restart(start, self.delay, self.time);

          // If the elapsed delay is less than our first sleep, start immediately.
          if (self.delay <= elapsed) start(elapsed - self.delay);
        }, 0, self.time);

        function start(elapsed) {
          var i, j, n, o;

          // If the state is not SCHEDULED, then we previously errored on start.
          if (self.state !== SCHEDULED) return stop();

          for (i in schedules) {
            o = schedules[i];
            if (o.name !== self.name) continue;

            // While this element already has a starting transition during this frame,
            // defer starting an interrupting transition until that transition has a
            // chance to tick (and possibly end); see d3/d3-transition#54!
            if (o.state === STARTED) return d3Timer.timeout(start);

            // Interrupt the active transition, if any.
            if (o.state === RUNNING) {
              o.state = ENDED;
              o.timer.stop();
              o.on.call("interrupt", node, node.__data__, o.index, o.group);
              delete schedules[i];
            }

            // Cancel any pre-empted transitions.
            else if (+i < id) {
                o.state = ENDED;
                o.timer.stop();
                o.on.call("cancel", node, node.__data__, o.index, o.group);
                delete schedules[i];
              }
          }

          // Defer the first tick to end of the current frame; see d3/d3#1576.
          // Note the transition may be canceled after start and before the first tick!
          // Note this must be scheduled before the start event; see d3/d3-transition#16!
          // Assuming this is successful, subsequent callbacks go straight to tick.
          d3Timer.timeout(function () {
            if (self.state === STARTED) {
              self.state = RUNNING;
              self.timer.restart(tick, self.delay, self.time);
              tick(elapsed);
            }
          });

          // Dispatch the start event.
          // Note this must be done before the tween are initialized.
          self.state = STARTING;
          self.on.call("start", node, node.__data__, self.index, self.group);
          if (self.state !== STARTING) return; // interrupted
          self.state = STARTED;

          // Initialize the tween, deleting null tween.
          tween = new Array(n = self.tween.length);
          for (i = 0, j = -1; i < n; ++i) {
            if (o = self.tween[i].value.call(node, node.__data__, self.index, self.group)) {
              tween[++j] = o;
            }
          }
          tween.length = j + 1;
        }

        function tick(elapsed) {
          var t = elapsed < self.duration ? self.ease.call(null, elapsed / self.duration) : (self.timer.restart(stop), self.state = ENDING, 1),
              i = -1,
              n = tween.length;

          while (++i < n) {
            tween[i].call(node, t);
          }

          // Dispatch the end event.
          if (self.state === ENDING) {
            self.on.call("end", node, node.__data__, self.index, self.group);
            stop();
          }
        }

        function stop() {
          self.state = ENDED;
          self.timer.stop();
          delete schedules[id];
          for (var i in schedules) return; // eslint-disable-line no-unused-vars
          delete node.__transition;
        }
      }

      function interrupt(node, name) {
        var schedules = node.__transition,
            schedule$$1,
            active,
            empty = true,
            i;

        if (!schedules) return;

        name = name == null ? null : name + "";

        for (i in schedules) {
          if ((schedule$$1 = schedules[i]).name !== name) {
            empty = false;continue;
          }
          active = schedule$$1.state > STARTING && schedule$$1.state < ENDING;
          schedule$$1.state = ENDED;
          schedule$$1.timer.stop();
          schedule$$1.on.call(active ? "interrupt" : "cancel", node, node.__data__, schedule$$1.index, schedule$$1.group);
          delete schedules[i];
        }

        if (empty) delete node.__transition;
      }

      function tweenRemove(id, name) {
        var tween0, tween1;
        return function () {
          var schedule$$1 = set(this, id),
              tween = schedule$$1.tween;

          // If this node shared tween with the previous node,
          // just assign the updated shared tween and we’re done!
          // Otherwise, copy-on-write.
          if (tween !== tween0) {
            tween1 = tween0 = tween;
            for (var i = 0, n = tween1.length; i < n; ++i) {
              if (tween1[i].name === name) {
                tween1 = tween1.slice();
                tween1.splice(i, 1);
                break;
              }
            }
          }

          schedule$$1.tween = tween1;
        };
      }

      function tweenFunction(id, name, value) {
        var tween0, tween1;
        if (typeof value !== "function") throw new Error();
        return function () {
          var schedule$$1 = set(this, id),
              tween = schedule$$1.tween;

          // If this node shared tween with the previous node,
          // just assign the updated shared tween and we’re done!
          // Otherwise, copy-on-write.
          if (tween !== tween0) {
            tween1 = (tween0 = tween).slice();
            for (var t = { name: name, value: value }, i = 0, n = tween1.length; i < n; ++i) {
              if (tween1[i].name === name) {
                tween1[i] = t;
                break;
              }
            }
            if (i === n) tween1.push(t);
          }

          schedule$$1.tween = tween1;
        };
      }

      function transition_tween(name, value) {
        var id = this._id;

        name += "";

        if (arguments.length < 2) {
          var tween = get(this.node(), id).tween;
          for (var i = 0, n = tween.length, t; i < n; ++i) {
            if ((t = tween[i]).name === name) {
              return t.value;
            }
          }
          return null;
        }

        return this.each((value == null ? tweenRemove : tweenFunction)(id, name, value));
      }

      function tweenValue(transition, name, value) {
        var id = transition._id;

        transition.each(function () {
          var schedule$$1 = set(this, id);
          (schedule$$1.value || (schedule$$1.value = {}))[name] = value.apply(this, arguments);
        });

        return function (node) {
          return get(node, id).value[name];
        };
      }

      function interpolate(a, b) {
        var c;
        return (typeof b === "number" ? d3Interpolate.interpolateNumber : b instanceof d3Color.color ? d3Interpolate.interpolateRgb : (c = d3Color.color(b)) ? (b = c, d3Interpolate.interpolateRgb) : d3Interpolate.interpolateString)(a, b);
      }

      function attrRemove(name) {
        return function () {
          this.removeAttribute(name);
        };
      }

      function attrRemoveNS(fullname) {
        return function () {
          this.removeAttributeNS(fullname.space, fullname.local);
        };
      }

      function attrConstant(name, interpolate$$1, value1) {
        var string00, interpolate0;
        return function () {
          var string0 = this.getAttribute(name);
          return string0 === value1 + "" ? null : string0 === string00 ? interpolate0 : interpolate0 = interpolate$$1(string00 = string0, value1);
        };
      }

      function attrConstantNS(fullname, interpolate$$1, value1) {
        var string00, interpolate0;
        return function () {
          var string0 = this.getAttributeNS(fullname.space, fullname.local);
          return string0 === value1 + "" ? null : string0 === string00 ? interpolate0 : interpolate0 = interpolate$$1(string00 = string0, value1);
        };
      }

      function attrFunction(name, interpolate$$1, value) {
        var string00, string10, interpolate0;
        return function () {
          var string0,
              value1 = value(this),
              string1;
          if (value1 == null) return void this.removeAttribute(name);
          string0 = this.getAttribute(name);
          string1 = value1 + "";
          return string0 === string1 ? null : string0 === string00 && string1 === string10 ? interpolate0 : (string10 = string1, interpolate0 = interpolate$$1(string00 = string0, value1));
        };
      }

      function attrFunctionNS(fullname, interpolate$$1, value) {
        var string00, string10, interpolate0;
        return function () {
          var string0,
              value1 = value(this),
              string1;
          if (value1 == null) return void this.removeAttributeNS(fullname.space, fullname.local);
          string0 = this.getAttributeNS(fullname.space, fullname.local);
          string1 = value1 + "";
          return string0 === string1 ? null : string0 === string00 && string1 === string10 ? interpolate0 : (string10 = string1, interpolate0 = interpolate$$1(string00 = string0, value1));
        };
      }

      function attrInterpolate(name, i) {
        return function (t) {
          this.setAttribute(name, i(t));
        };
      }

      function attrInterpolateNS(fullname, i) {
        return function (t) {
          this.setAttributeNS(fullname.space, fullname.local, i(t));
        };
      }

      function attrTweenNS(fullname, value) {
        var t0, i0;
        function tween() {
          var i = value.apply(this, arguments);
          if (i !== i0) t0 = (i0 = i) && attrInterpolateNS(fullname, i);
          return t0;
        }
        tween._value = value;
        return tween;
      }

      function attrTween(name, value) {
        var t0, i0;
        function tween() {
          var i = value.apply(this, arguments);
          if (i !== i0) t0 = (i0 = i) && attrInterpolate(name, i);
          return t0;
        }
        tween._value = value;
        return tween;
      }

      function delayFunction(id, value) {
        return function () {
          init(this, id).delay = +value.apply(this, arguments);
        };
      }

      function delayConstant(id, value) {
        return value = +value, function () {
          init(this, id).delay = value;
        };
      }

      function transition_delay(value) {
        var id = this._id;

        return arguments.length ? this.each((typeof value === "function" ? delayFunction : delayConstant)(id, value)) : get(this.node(), id).delay;
      }

      function durationFunction(id, value) {
        return function () {
          set(this, id).duration = +value.apply(this, arguments);
        };
      }

      function durationConstant(id, value) {
        return value = +value, function () {
          set(this, id).duration = value;
        };
      }

      function transition_duration(value) {
        var id = this._id;

        return arguments.length ? this.each((typeof value === "function" ? durationFunction : durationConstant)(id, value)) : get(this.node(), id).duration;
      }

      function easeConstant(id, value) {
        if (typeof value !== "function") throw new Error();
        return function () {
          set(this, id).ease = value;
        };
      }

      function transition_ease(value) {
        var id = this._id;

        return arguments.length ? this.each(easeConstant(id, value)) : get(this.node(), id).ease;
      }

      function start(name) {
        return (name + "").trim().split(/^|\s+/).every(function (t) {
          var i = t.indexOf(".");
          if (i >= 0) t = t.slice(0, i);
          return !t || t === "start";
        });
      }

      function onFunction(id, name, listener) {
        var on0,
            on1,
            sit = start(name) ? init : set;
        return function () {
          var schedule$$1 = sit(this, id),
              on = schedule$$1.on;

          // If this node shared a dispatch with the previous node,
          // just assign the updated shared dispatch and we’re done!
          // Otherwise, copy-on-write.
          if (on !== on0) (on1 = (on0 = on).copy()).on(name, listener);

          schedule$$1.on = on1;
        };
      }

      function transition_on(name, listener) {
        var id = this._id;

        return arguments.length < 2 ? get(this.node(), id).on.on(name) : this.each(onFunction(id, name, listener));
      }

      function removeFunction(id) {
        return function () {
          var parent = this.parentNode;
          for (var i in this.__transition) if (+i !== id) return;
          if (parent) parent.removeChild(this);
        };
      }

      function transition_select(select) {
        var name = this._name,
            id = this._id;

        if (typeof select !== "function") select = d3Selection.selector(select);

        for (var groups = this._groups, m = groups.length, subgroups = new Array(m), j = 0; j < m; ++j) {
          for (var group = groups[j], n = group.length, subgroup = subgroups[j] = new Array(n), node, subnode, i = 0; i < n; ++i) {
            if ((node = group[i]) && (subnode = select.call(node, node.__data__, i, group))) {
              if ("__data__" in node) subnode.__data__ = node.__data__;
              subgroup[i] = subnode;
              schedule(subgroup[i], name, id, i, subgroup, get(node, id));
            }
          }
        }

        return new Transition(subgroups, this._parents, name, id);
      }

      function transition_selectAll(select) {
        var name = this._name,
            id = this._id;

        if (typeof select !== "function") select = d3Selection.selectorAll(select);

        for (var groups = this._groups, m = groups.length, subgroups = [], parents = [], j = 0; j < m; ++j) {
          for (var group = groups[j], n = group.length, node, i = 0; i < n; ++i) {
            if (node = group[i]) {
              for (var children = select.call(node, node.__data__, i, group), child, inherit = get(node, id), k = 0, l = children.length; k < l; ++k) {
                if (child = children[k]) {
                  schedule(child, name, id, k, children, inherit);
                }
              }
              subgroups.push(children);
              parents.push(node);
            }
          }
        }

        return new Transition(subgroups, parents, name, id);
      }

      var Selection = d3Selection.selection.prototype.constructor;

      function styleNull(name, interpolate$$1) {
        var string00, string10, interpolate0;
        return function () {
          var string0 = d3Selection.style(this, name),
              string1 = (this.style.removeProperty(name), d3Selection.style(this, name));
          return string0 === string1 ? null : string0 === string00 && string1 === string10 ? interpolate0 : interpolate0 = interpolate$$1(string00 = string0, string10 = string1);
        };
      }

      function styleRemove(name) {
        return function () {
          this.style.removeProperty(name);
        };
      }

      function styleConstant(name, interpolate$$1, value1) {
        var string00, interpolate0;
        return function () {
          var string0 = d3Selection.style(this, name);
          return string0 === value1 + "" ? null : string0 === string00 ? interpolate0 : interpolate0 = interpolate$$1(string00 = string0, value1);
        };
      }

      function styleFunction(name, interpolate$$1, value) {
        var string00, string10, interpolate0;
        return function () {
          var string0 = d3Selection.style(this, name),
              value1 = value(this),
              string1 = value1 + "";
          if (value1 == null) string1 = value1 = (this.style.removeProperty(name), d3Selection.style(this, name));
          return string0 === string1 ? null : string0 === string00 && string1 === string10 ? interpolate0 : (string10 = string1, interpolate0 = interpolate$$1(string00 = string0, value1));
        };
      }

      function styleMaybeRemove(id, name) {
        var on0,
            on1,
            listener0,
            key = "style." + name,
            remove;
        return function () {
          var schedule$$1 = set(this, id),
              on = schedule$$1.on,
              listener = schedule$$1.value[key] == null ? remove || (remove = styleRemove(name)) : undefined;

          // If this node shared a dispatch with the previous node,
          // just assign the updated shared dispatch and we’re done!
          // Otherwise, copy-on-write.
          if (on !== on0 || listener0 !== listener) (on1 = (on0 = on).copy()).on("end." + key, listener0 = listener);

          schedule$$1.on = on1;
        };
      }

      function styleInterpolate(name, i, priority) {
        return function (t) {
          this.style.setProperty(name, i(t), priority);
        };
      }

      function styleTween(name, value, priority) {
        var t, i0;
        function tween() {
          var i = value.apply(this, arguments);
          if (i !== i0) t = (i0 = i) && styleInterpolate(name, i, priority);
          return t;
        }
        tween._value = value;
        return tween;
      }

      function textConstant(value) {
        return function () {
          this.textContent = value;
        };
      }

      function textFunction(value) {
        return function () {
          var value1 = value(this);
          this.textContent = value1 == null ? "" : value1;
        };
      }

      var id = 0;

      function Transition(groups, parents, name, id) {
        this._groups = groups;
        this._parents = parents;
        this._name = name;
        this._id = id;
      }

      function transition(name) {
        return d3Selection.selection().transition(name);
      }

      function newId() {
        return ++id;
      }

      var selection_prototype = d3Selection.selection.prototype;

      Transition.prototype = transition.prototype = {
        constructor: Transition,
        select: transition_select,
        selectAll: transition_selectAll,
        filter: function transition_filter(match) {
          if (typeof match !== "function") match = d3Selection.matcher(match);

          for (var groups = this._groups, m = groups.length, subgroups = new Array(m), j = 0; j < m; ++j) {
            for (var group = groups[j], n = group.length, subgroup = subgroups[j] = [], node, i = 0; i < n; ++i) {
              if ((node = group[i]) && match.call(node, node.__data__, i, group)) {
                subgroup.push(node);
              }
            }
          }

          return new Transition(subgroups, this._parents, this._name, this._id);
        },
        merge: function transition_merge(transition$$1) {
          if (transition$$1._id !== this._id) throw new Error();

          for (var groups0 = this._groups, groups1 = transition$$1._groups, m0 = groups0.length, m1 = groups1.length, m = Math.min(m0, m1), merges = new Array(m0), j = 0; j < m; ++j) {
            for (var group0 = groups0[j], group1 = groups1[j], n = group0.length, merge = merges[j] = new Array(n), node, i = 0; i < n; ++i) {
              if (node = group0[i] || group1[i]) {
                merge[i] = node;
              }
            }
          }

          for (; j < m0; ++j) {
            merges[j] = groups0[j];
          }

          return new Transition(merges, this._parents, this._name, this._id);
        },
        selection: function transition_selection() {
          return new Selection(this._groups, this._parents);
        },
        transition: function transition_transition() {
          var name = this._name,
              id0 = this._id,
              id1 = newId();

          for (var groups = this._groups, m = groups.length, j = 0; j < m; ++j) {
            for (var group = groups[j], n = group.length, node, i = 0; i < n; ++i) {
              if (node = group[i]) {
                var inherit = get(node, id0);
                schedule(node, name, id1, i, group, {
                  time: inherit.time + inherit.delay + inherit.duration,
                  delay: 0,
                  duration: inherit.duration,
                  ease: inherit.ease
                });
              }
            }
          }

          return new Transition(groups, this._parents, name, id1);
        },
        call: selection_prototype.call,
        nodes: selection_prototype.nodes,
        node: selection_prototype.node,
        size: selection_prototype.size,
        empty: selection_prototype.empty,
        each: selection_prototype.each,
        on: transition_on,
        attr: function transition_attr(name, value) {
          var fullname = d3Selection.namespace(name),
              i = fullname === "transform" ? d3Interpolate.interpolateTransformSvg : interpolate;
          return this.attrTween(name, typeof value === "function" ? (fullname.local ? attrFunctionNS : attrFunction)(fullname, i, tweenValue(this, "attr." + name, value)) : value == null ? (fullname.local ? attrRemoveNS : attrRemove)(fullname) : (fullname.local ? attrConstantNS : attrConstant)(fullname, i, value));
        },
        attrTween: function transition_attrTween(name, value) {
          var key = "attr." + name;
          if (arguments.length < 2) return (key = this.tween(key)) && key._value;
          if (value == null) return this.tween(key, null);
          if (typeof value !== "function") throw new Error();
          var fullname = d3Selection.namespace(name);
          return this.tween(key, (fullname.local ? attrTweenNS : attrTween)(fullname, value));
        },
        style: function transition_style(name, value, priority) {
          var i = (name += "") === "transform" ? d3Interpolate.interpolateTransformCss : interpolate;
          return value == null ? this.styleTween(name, styleNull(name, i)).on("end.style." + name, styleRemove(name)) : typeof value === "function" ? this.styleTween(name, styleFunction(name, i, tweenValue(this, "style." + name, value))).each(styleMaybeRemove(this._id, name)) : this.styleTween(name, styleConstant(name, i, value), priority).on("end.style." + name, null);
        },
        styleTween: function transition_styleTween(name, value, priority) {
          var key = "style." + (name += "");
          if (arguments.length < 2) return (key = this.tween(key)) && key._value;
          if (value == null) return this.tween(key, null);
          if (typeof value !== "function") throw new Error();
          return this.tween(key, styleTween(name, value, priority == null ? "" : priority));
        },
        text: function transition_text(value) {
          return this.tween("text", typeof value === "function" ? textFunction(tweenValue(this, "text", value)) : textConstant(value == null ? "" : value + ""));
        },
        remove: function transition_remove() {
          return this.on("end.remove", removeFunction(this._id));
        },
        tween: transition_tween,
        delay: transition_delay,
        duration: transition_duration,
        ease: transition_ease,
        end: function transition_end() {
          var on0,
              on1,
              that = this,
              id = that._id,
              size = that.size();
          return new Promise(function (resolve, reject) {
            var cancel = { value: reject },
                end = { value: function () {
                if (--size === 0) resolve();
              } };

            that.each(function () {
              var schedule$$1 = set(this, id),
                  on = schedule$$1.on;

              // If this node shared a dispatch with the previous node,
              // just assign the updated shared dispatch and we’re done!
              // Otherwise, copy-on-write.
              if (on !== on0) {
                on1 = (on0 = on).copy();
                on1._.cancel.push(cancel);
                on1._.interrupt.push(cancel);
                on1._.end.push(end);
              }

              schedule$$1.on = on1;
            });
          });
        }
      };

      var defaultTiming = {
        time: null, // Set on use.
        delay: 0,
        duration: 250,
        ease: d3Ease.easeCubicInOut
      };

      function inherit(node, id) {
        var timing;
        while (!(timing = node.__transition) || !(timing = timing[id])) {
          if (!(node = node.parentNode)) {
            return defaultTiming.time = d3Timer.now(), defaultTiming;
          }
        }
        return timing;
      }

      function selection_transition(name) {
        var id, timing;

        if (name instanceof Transition) {
          id = name._id, name = name._name;
        } else {
          id = newId(), (timing = defaultTiming).time = d3Timer.now(), name = name == null ? null : name + "";
        }

        for (var groups = this._groups, m = groups.length, j = 0; j < m; ++j) {
          for (var group = groups[j], n = group.length, node, i = 0; i < n; ++i) {
            if (node = group[i]) {
              schedule(node, name, id, i, group, timing || inherit(node, id));
            }
          }
        }

        return new Transition(groups, this._parents, name, id);
      }

      d3Selection.selection.prototype.interrupt = function selection_interrupt(name) {
        return this.each(function () {
          interrupt(this, name);
        });
      };
      d3Selection.selection.prototype.transition = selection_transition;

      var root = [null];

      exports.transition = transition;
      exports.active = function active(node, name) {
        var schedules = node.__transition,
            schedule$$1,
            i;

        if (schedules) {
          name = name == null ? null : name + "";
          for (i in schedules) {
            if ((schedule$$1 = schedules[i]).state > SCHEDULED && schedule$$1.name === name) {
              return new Transition([[node]], root, name, +i);
            }
          }
        }

        return null;
      };
      exports.interrupt = interrupt;

      Object.defineProperty(exports, '__esModule', { value: true });
    });
  }
});
//# sourceMappingURL=d3-transition.js.map