Liferay.Loader.define("commerce-dashboard-web@3.0.22/js/utils/loadData.es", ['module', 'exports', 'require', 'frontend-js-web'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.formatCategoriesForChart = formatCategoriesForChart;
    exports.formatDataForChart = formatDataForChart;
    exports.formatPointForForecast = formatPointForForecast;
    exports.formatPointsForChart = formatPointsForChart;
    exports.getCategoriesArray = getCategoriesArray;
    exports.getDates = getDates;
    exports.getDateString = getDateString;
    exports.getLineTypesForChart = getLineTypesForChart;
    exports.getPoints = getPoints;
    exports.getPredictionDate = getPredictionDate;
    exports.hasNoActualNorForecastValue = hasNoActualNorForecastValue;
    exports.getValuesForCategory = getValuesForCategory;
    exports.isPartOfCategory = isPartOfCategory;
    exports.loadData = loadData;
    exports.parseData = parseData;
    exports.NULL_VALUE = void 0;

    var _frontendJsWeb = require("frontend-js-web");

    /**
     * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
     *
     * The contents of this file are subject to the terms of the Liferay Enterprise
     * Subscription License ("License"). You may not use this file except in
     * compliance with the License. You can obtain a copy of the License by
     * contacting Liferay, Inc. See the License for the specific language governing
     * permissions and limitations under the License, including but not limited to
     * distribution rights of the Software.
     */

    /* eslint-disable require-jsdoc */
    const NULL_VALUE = 1.4e-45;
    exports.NULL_VALUE = NULL_VALUE;
    const headers = {
      'Content-Type': 'application/json'
    };

    function byDate(a, b) {
      return new Date(a.timestamp) - new Date(b.timestamp);
    }

    function byName(a, b) {
      return a.name.localeCompare(b.name);
    }

    function formatCategoriesForChart(categories) {
      return categories.reduce((a, c) => Object.assign(a, {
        ["".concat(c.id)]: c.name
      }), {});
    }

    function formatDataForChart(points = []) {
      const categories = getCategoriesArray(points);
      return {
        axis: {
          x: {
            type: 'timeseries'
          }
        },
        data: {
          columns: formatPointsForChart(points, categories),
          names: formatCategoriesForChart(categories),
          type: 'predictive',
          types: getLineTypesForChart(categories),
          x: 'x'
        },
        predictionDate: getPredictionDate(points)
      };
    }

    function formatPointForForecast(point) {
      return point.actual !== NULL_VALUE ? point.actual : {
        high: point.forecastUpperBound,
        low: point.forecastLowerBound,
        mid: point.forecast
      };
    }

    function formatPointsForChart(points, categories) {
      return !points.length ? [] : [['x', ...getDates(points)], ...categories.map(c => ["".concat(c.id), ...getValuesForCategory(points, c)])];
    }

    function getCategoriesArray(items = []) {
      return [...items.reduce((a, c) => {
        a.set(c.category, c.categoryTitle);
        return a;
      }, new Map()).entries()].map(([id, name]) => ({
        id,
        name
      })).sort(byName);
    }

    function getDates(points) {
      return points.filter(isPartOfCategory(points[0].category)).map(d => getDateString(d.timestamp));
    }

    function getDateString(ts) {
      return (ts || '').slice(0, 10);
    }

    function getLineTypesForChart(categories) {
      return categories.reduce((a, c) => Object.assign(a, {
        ["".concat(c.id)]: 'area-line-range'
      }), {});
    }

    function getPoints({
      items
    }) {
      return items;
    }

    function getPredictionDate(points) {
      return !points.length ? null : getDateString(points.slice().reverse().find(d => d.actual !== NULL_VALUE).timestamp);
    }

    function hasNoActualNorForecastValue({
      actual,
      forecast
    }) {
      return !(actual === NULL_VALUE && forecast === NULL_VALUE);
    }

    function getValuesForCategory(points, category) {
      return points.filter(isPartOfCategory(category.id)).filter(hasNoActualNorForecastValue).map(formatPointForForecast);
    }

    function isPartOfCategory(id) {
      return ({
        category
      }) => category === id;
    }

    function loadData(url) {
      return parseData((0, _frontendJsWeb.fetch)(url, {
        headers
      }).then(responseToJson));
    }

    function parseData(loadData) {
      return loadData.then(getPoints).then(sortPointsByDate).then(formatDataForChart);
    }

    function responseToJson(response) {
      return response.json();
    }

    function sortPointsByDate(points = []) {
      return points.sort(byDate);
    }
    //# sourceMappingURL=loadData.es.js.map
  }
});
//# sourceMappingURL=loadData.es.js.map