Liferay.Loader.define("commerce-dashboard-web@3.0.22/js/forecast/ForecastChart.es", ['module', 'exports', 'require', 'frontend-js-react-web$react', '../ChartWrapper.es', '../utils/index.es'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = ForecastChart;

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    var _ChartWrapper = _interopRequireDefault(require("../ChartWrapper.es"));

    var _index = require("../utils/index.es");

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || typeof obj !== "object" && typeof obj !== "function") {
        return { default: obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj.default = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    /**
     * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
     *
     * The contents of this file are subject to the terms of the Liferay Enterprise
     * Subscription License ("License"). You may not use this file except in
     * compliance with the License. You can obtain a copy of the License by
     * contacting Liferay, Inc. See the License for the specific language governing
     * permissions and limitations under the License, including but not limited to
     * distribution rights of the Software.
     */
    function ForecastChart({
      APIBaseUrl,
      accountIds: initialAccountsIds = [],
      categoryIds = [],
      noAccountErrorMessage,
      noDataErrorMessage
    }) {
      const [loading, setLoading] = (0, _react.useState)(true);
      const [chartData, setChartData] = (0, _react.useState)({});
      const [accountsId, setAccountId] = (0, _react.useState)(initialAccountsIds);
      Liferay.on('accountSelected', ({
        accountId
      }) => setAccountId([accountId]));

      function startLoading() {
        setLoading(true);
      }
      /* eslint-disable-next-line react-hooks/exhaustive-deps */

      (0, _react.useEffect)(function updateData() {
        const formattedAccountIds = accountsId.map(id => "accountIds=".concat(id)).join('&');
        const formattedCategoryIds = categoryIds.length ? '&' + categoryIds.map(id => "categoryIds=".concat(id)).join('&') : '';
        const APIUrl = "".concat(APIBaseUrl, "?").concat(formattedAccountIds).concat(formattedCategoryIds, "&pageSize=200");
        startLoading();
        (0, _index.loadData)(APIUrl).then(setChartData);
      }, [accountsId]);
      (0, _react.useEffect)(function stopLoading() {
        setLoading(!chartData.data);
      }, [chartData]);
      return !accountsId ? /*#__PURE__*/_react.default.createElement("p", null, noAccountErrorMessage) : /*#__PURE__*/_react.default.createElement(_ChartWrapper.default, {
        data: chartData,
        loading: loading,
        noDataErrorMessage: noDataErrorMessage
      });
    }
    //# sourceMappingURL=ForecastChart.es.js.map
  }
});
//# sourceMappingURL=ForecastChart.es.js.map