Liferay.Loader.define('commerce-dashboard-web$d3-ease@1.0.5/dist/d3-ease', ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  // https://d3js.org/d3-ease/ v1.0.5 Copyright 2018 Mike Bostock
  (function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports) : typeof define === 'function' && define.amd ? define(['exports'], factory) : factory(global.d3 = global.d3 || {});
  })(this, function (exports) {
    'use strict';

    function quadInOut(t) {
      return ((t *= 2) <= 1 ? t * t : --t * (2 - t) + 1) / 2;
    }

    function cubicInOut(t) {
      return ((t *= 2) <= 1 ? t * t * t : (t -= 2) * t * t + 2) / 2;
    }

    var exponent = 3;

    var polyIn = function custom(e) {
      e = +e;

      function polyIn(t) {
        return Math.pow(t, e);
      }

      polyIn.exponent = custom;

      return polyIn;
    }(exponent);

    var polyOut = function custom(e) {
      e = +e;

      function polyOut(t) {
        return 1 - Math.pow(1 - t, e);
      }

      polyOut.exponent = custom;

      return polyOut;
    }(exponent);

    var polyInOut = function custom(e) {
      e = +e;

      function polyInOut(t) {
        return ((t *= 2) <= 1 ? Math.pow(t, e) : 2 - Math.pow(2 - t, e)) / 2;
      }

      polyInOut.exponent = custom;

      return polyInOut;
    }(exponent);

    var pi = Math.PI,
        halfPi = pi / 2;

    function sinInOut(t) {
      return (1 - Math.cos(pi * t)) / 2;
    }

    function expInOut(t) {
      return ((t *= 2) <= 1 ? Math.pow(2, 10 * t - 10) : 2 - Math.pow(2, 10 - 10 * t)) / 2;
    }

    function circleInOut(t) {
      return ((t *= 2) <= 1 ? 1 - Math.sqrt(1 - t * t) : Math.sqrt(1 - (t -= 2) * t) + 1) / 2;
    }

    var b1 = 4 / 11,
        b0 = 1 / b1 / b1;

    function bounceOut(t) {
      return (t = +t) < b1 ? b0 * t * t : t < 8 / 11 ? b0 * (t -= 6 / 11) * t + 3 / 4 : t < 10 / 11 ? b0 * (t -= 9 / 11) * t + 15 / 16 : b0 * (t -= 21 / 22) * t + 63 / 64;
    }

    var overshoot = 1.70158;

    var backIn = function custom(s) {
      s = +s;

      function backIn(t) {
        return t * t * ((s + 1) * t - s);
      }

      backIn.overshoot = custom;

      return backIn;
    }(overshoot);

    var backOut = function custom(s) {
      s = +s;

      function backOut(t) {
        return --t * t * ((s + 1) * t + s) + 1;
      }

      backOut.overshoot = custom;

      return backOut;
    }(overshoot);

    var backInOut = function custom(s) {
      s = +s;

      function backInOut(t) {
        return ((t *= 2) < 1 ? t * t * ((s + 1) * t - s) : (t -= 2) * t * ((s + 1) * t + s) + 2) / 2;
      }

      backInOut.overshoot = custom;

      return backInOut;
    }(overshoot);

    var tau = 2 * Math.PI,
        amplitude = 1,
        period = 0.3;

    var elasticIn = function custom(a, p) {
      var s = Math.asin(1 / (a = Math.max(1, a))) * (p /= tau);

      function elasticIn(t) {
        return a * Math.pow(2, 10 * --t) * Math.sin((s - t) / p);
      }

      elasticIn.amplitude = function (a) {
        return custom(a, p * tau);
      };
      elasticIn.period = function (p) {
        return custom(a, p);
      };

      return elasticIn;
    }(amplitude, period);

    var elasticOut = function custom(a, p) {
      var s = Math.asin(1 / (a = Math.max(1, a))) * (p /= tau);

      function elasticOut(t) {
        return 1 - a * Math.pow(2, -10 * (t = +t)) * Math.sin((t + s) / p);
      }

      elasticOut.amplitude = function (a) {
        return custom(a, p * tau);
      };
      elasticOut.period = function (p) {
        return custom(a, p);
      };

      return elasticOut;
    }(amplitude, period);

    var elasticInOut = function custom(a, p) {
      var s = Math.asin(1 / (a = Math.max(1, a))) * (p /= tau);

      function elasticInOut(t) {
        return ((t = t * 2 - 1) < 0 ? a * Math.pow(2, 10 * t) * Math.sin((s - t) / p) : 2 - a * Math.pow(2, -10 * t) * Math.sin((s + t) / p)) / 2;
      }

      elasticInOut.amplitude = function (a) {
        return custom(a, p * tau);
      };
      elasticInOut.period = function (p) {
        return custom(a, p);
      };

      return elasticInOut;
    }(amplitude, period);

    exports.easeLinear = function linear(t) {
      return +t;
    };
    exports.easeQuad = quadInOut;
    exports.easeQuadIn = function quadIn(t) {
      return t * t;
    };
    exports.easeQuadOut = function quadOut(t) {
      return t * (2 - t);
    };
    exports.easeQuadInOut = quadInOut;
    exports.easeCubic = cubicInOut;
    exports.easeCubicIn = function cubicIn(t) {
      return t * t * t;
    };
    exports.easeCubicOut = function cubicOut(t) {
      return --t * t * t + 1;
    };
    exports.easeCubicInOut = cubicInOut;
    exports.easePoly = polyInOut;
    exports.easePolyIn = polyIn;
    exports.easePolyOut = polyOut;
    exports.easePolyInOut = polyInOut;
    exports.easeSin = sinInOut;
    exports.easeSinIn = function sinIn(t) {
      return 1 - Math.cos(t * halfPi);
    };
    exports.easeSinOut = function sinOut(t) {
      return Math.sin(t * halfPi);
    };
    exports.easeSinInOut = sinInOut;
    exports.easeExp = expInOut;
    exports.easeExpIn = function expIn(t) {
      return Math.pow(2, 10 * t - 10);
    };
    exports.easeExpOut = function expOut(t) {
      return 1 - Math.pow(2, -10 * t);
    };
    exports.easeExpInOut = expInOut;
    exports.easeCircle = circleInOut;
    exports.easeCircleIn = function circleIn(t) {
      return 1 - Math.sqrt(1 - t * t);
    };
    exports.easeCircleOut = function circleOut(t) {
      return Math.sqrt(1 - --t * t);
    };
    exports.easeCircleInOut = circleInOut;
    exports.easeBounce = bounceOut;
    exports.easeBounceIn = function bounceIn(t) {
      return 1 - bounceOut(1 - t);
    };
    exports.easeBounceOut = bounceOut;
    exports.easeBounceInOut = function bounceInOut(t) {
      return ((t *= 2) <= 1 ? 1 - bounceOut(1 - t) : bounceOut(t - 1) + 1) / 2;
    };
    exports.easeBack = backInOut;
    exports.easeBackIn = backIn;
    exports.easeBackOut = backOut;
    exports.easeBackInOut = backInOut;
    exports.easeElastic = elasticOut;
    exports.easeElasticIn = elasticIn;
    exports.easeElasticOut = elasticOut;
    exports.easeElasticInOut = elasticInOut;

    Object.defineProperty(exports, '__esModule', { value: true });
  });
});
//# sourceMappingURL=d3-ease.js.map