Liferay.Loader.define("commerce-dashboard-web@2.0.8/js/forecast/ForecastChart.es", ['module', 'exports', 'require', 'frontend-js-react-web$react', '../ChartWrapper.es', '../utils/index.es'], function (module, exports, require) {
  var define = undefined;
  function _typeof(obj) {
    "@babel/helpers - typeof";
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = ForecastChart;

  var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

  var _ChartWrapper = _interopRequireDefault(require("../ChartWrapper.es"));

  var _index = require("../utils/index.es");

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _getRequireWildcardCache() {
    if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
      return cache;
    };return cache;
  }

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
      return { "default": obj };
    }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
      return cache.get(obj);
    }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
      if (Object.prototype.hasOwnProperty.call(obj, key)) {
        var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
          Object.defineProperty(newObj, key, desc);
        } else {
          newObj[key] = obj[key];
        }
      }
    }newObj["default"] = obj;if (cache) {
      cache.set(obj, newObj);
    }return newObj;
  }

  function _slicedToArray(arr, i) {
    return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
  }

  function _nonIterableRest() {
    throw new TypeError("Invalid attempt to destructure non-iterable instance");
  }

  function _iterableToArrayLimit(arr, i) {
    if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
      return;
    }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
      for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
        _arr.push(_s.value);if (i && _arr.length === i) break;
      }
    } catch (err) {
      _d = true;_e = err;
    } finally {
      try {
        if (!_n && _i["return"] != null) _i["return"]();
      } finally {
        if (_d) throw _e;
      }
    }return _arr;
  }

  function _arrayWithHoles(arr) {
    if (Array.isArray(arr)) return arr;
  }

  function ForecastChart(_ref) {
    var APIBaseUrl = _ref.APIBaseUrl,
        _ref$accountIds = _ref.accountIds,
        initialAccountsIds = _ref$accountIds === void 0 ? [] : _ref$accountIds,
        _ref$categoryIds = _ref.categoryIds,
        categoryIds = _ref$categoryIds === void 0 ? [] : _ref$categoryIds,
        noAccountErrorMessage = _ref.noAccountErrorMessage,
        noDataErrorMessage = _ref.noDataErrorMessage;

    var _useState = (0, _react.useState)(true),
        _useState2 = _slicedToArray(_useState, 2),
        loading = _useState2[0],
        setLoading = _useState2[1];

    var _useState3 = (0, _react.useState)({}),
        _useState4 = _slicedToArray(_useState3, 2),
        chartData = _useState4[0],
        setChartData = _useState4[1];

    var _useState5 = (0, _react.useState)(initialAccountsIds),
        _useState6 = _slicedToArray(_useState5, 2),
        accountsId = _useState6[0],
        setAccountId = _useState6[1];

    Liferay.on('accountSelected', function (_ref2) {
      var accountId = _ref2.accountId;
      return setAccountId([accountId]);
    });

    function startLoading() {
      setLoading(true);
    }

    (0, _react.useEffect)(function updateData() {
      var formattedAccountIds = accountsId.map(function (id) {
        return "accountIds=".concat(id);
      }).join('&');
      var formattedCategoryIds = categoryIds.length ? '&' + categoryIds.map(function (id) {
        return "categoryIds=".concat(id);
      }).join('&') : '';
      var APIUrl = "".concat(APIBaseUrl, "?").concat(formattedAccountIds).concat(formattedCategoryIds, "&pageSize=200");
      startLoading();
      (0, _index.loadData)(APIUrl).then(setChartData);
    }, [accountsId]);
    (0, _react.useEffect)(function stopLoading() {
      setLoading(!chartData.data);
    }, [chartData]);
    return !accountsId ? _react["default"].createElement("p", null, noAccountErrorMessage) : _react["default"].createElement(_ChartWrapper["default"], {
      data: chartData,
      loading: loading,
      noDataErrorMessage: noDataErrorMessage
    });
  }
  //# sourceMappingURL=ForecastChart.es.js.map
});
//# sourceMappingURL=ForecastChart.es.js.map