Liferay.Loader.define("commerce-dashboard-web@2.0.7/js/utils/test/loadData", ['module', 'exports', 'require', '../loadData.es', '../mock/data'], function (module, exports, require) {
  var define = undefined;
  var _loadData = require("../loadData.es");

  var _data = require("../mock/data");

  /**
   * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
   *
   * The contents of this file are subject to the terms of the Liferay Enterprise
   * Subscription License ("License"). You may not use this file except in
   * compliance with the License. You can obtain a copy of the License by
   * contacting Liferay, Inc. See the License for the specific language governing
   * permissions and limitations under the License, including but not limited to
   * distribution rights of the Software.
   */

  /**
   * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
   *
   * This library is free software; you can redistribute it and/or modify it under
   * the terms of the GNU Lesser General Public License as published by the Free
   * Software Foundation; either version 2.1 of the License, or (at your option)
   * any later version.
   *
   * This library is distributed in the hope that it will be useful, but WITHOUT
   * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
   * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
   * details.
   */
  var categoriesSubset = (0, _loadData.getCategoriesArray)(_data.simpleInput.items);

  var loadData = function loadData(data) {
    return new Promise(function (resolve) {
      return resolve(data);
    });
  };

  describe('Chart loadData utils', function () {
    it('Format categories for chart', function () {
      expect((0, _loadData.formatCategoriesForChart)(categoriesSubset)).toEqual({
        1: 'Cat 1',
        2: 'Cat 2'
      });
    });
    it('Format point for forecast', function () {
      var pastItem = _data.simpleInput.items.find(function (i) {
        return i.actual !== 1.4e-45;
      });

      var futureItem = _data.simpleInput.items.find(function (i) {
        return i.actual === 1.4e-45;
      });

      expect((0, _loadData.formatPointForForecast)(pastItem)).toBe(pastItem.actual);
      expect((0, _loadData.formatPointForForecast)(futureItem)).toEqual({
        high: futureItem.forecastUpperBound,
        low: futureItem.forecastLowerBound,
        mid: futureItem.forecast
      });
    });
    it('Format points for chart', function () {
      expect((0, _loadData.formatPointsForChart)(_data.simpleInput.items, categoriesSubset)).toEqual([['x', '2019-04-01', '2019-05-01'], ['1', 15, {
        high: 18,
        low: 12,
        mid: 16
      }], ['2', 25, {
        high: 28,
        low: 22,
        mid: 26
      }]]);
      expect((0, _loadData.formatPointsForChart)([], [])).toEqual([]);
    });
    it('Get categories array', function () {
      expect((0, _loadData.getCategoriesArray)(_data.simpleInput.items)).toEqual([{
        id: 1,
        name: 'Cat 1'
      }, {
        id: 2,
        name: 'Cat 2'
      }]);
    });
    it('Get dates list', function () {
      expect((0, _loadData.getDates)(_data.simpleInput.items)).toEqual(['2019-04-01', '2019-05-01']);
    });
    it('Convert date to string', function () {
      expect((0, _loadData.getDateString)('2019-07-01T00:00:00Z')).toBe('2019-07-01');
      expect((0, _loadData.getDateString)('')).toBe('');
      expect((0, _loadData.getDateString)(undefined)).toBe('');
    });
    it('Get line types for chart', function () {
      expect((0, _loadData.getLineTypesForChart)(categoriesSubset)).toEqual({
        1: 'area-line-range',
        2: 'area-line-range'
      });
    });
    it('Extract points from data object', function () {
      expect((0, _loadData.getPoints)(_data.simpleInput)).toEqual(_data.simpleInput.items);
    });
    it('Find the prediction date', function () {
      expect((0, _loadData.getPredictionDate)(_data.input.items)).toBe('2019-11-01');
      expect((0, _loadData.getPredictionDate)(_data.simpleInput.items)).toBe('2019-04-01');
    });
    it('Get values for a category', function () {
      expect((0, _loadData.getValuesForCategory)(_data.simpleInput.items, {
        id: 1
      })).toEqual([15, {
        high: 18,
        low: 12,
        mid: 16
      }]);
    });
    it('Is part of a category', function () {
      expect((0, _loadData.isPartOfCategory)(1)({
        category: 1
      })).toBe(true);
      expect((0, _loadData.isPartOfCategory)(1)({
        category: 2
      })).toBe(false);
      expect((0, _loadData.isPartOfCategory)(2)({
        category: 1
      })).toBe(false);
    });
    it('Filters out points whose actual AND forecast values are NULL', function () {
      var invalidSample = {
        actual: _loadData.NULL_VALUE,
        forecast: _loadData.NULL_VALUE
      },
          validSample = {
        actual: 1232,
        forecast: _loadData.NULL_VALUE
      };
      var result = [invalidSample, validSample].filter(_loadData.hasNoActualNorForecastValue);
      expect(result).toEqual([validSample]);
    });
    it('Parse data', function () {
      return (0, _loadData.parseData)(loadData(_data.input)).then(function (data) {
        expect(data).toEqual(_data.output);
      });
    });
    it('Parse simple data', function () {
      return (0, _loadData.parseData)(loadData(_data.simpleInput)).then(function (data) {
        expect(data).toEqual(_data.simpleOutput);
      });
    });
  });
  //# sourceMappingURL=loadData.js.map
});
//# sourceMappingURL=loadData.js.map