Liferay.Loader.define("commerce-dashboard-web@2.0.5/js/ChartWrapper.es", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/charts', 'frontend-js-react-web$react', 'commerce-dashboard-web$resize-observer-polyfill'], function (module, exports, require) {
  var define = undefined;
  function _typeof(obj) {
    "@babel/helpers - typeof";
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = ChartWrapper;

  var _charts = _interopRequireDefault(require("@frontend-taglib-clay$clayui/charts"));

  var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

  var _resizeObserverPolyfill = _interopRequireDefault(require("commerce-dashboard-web$resize-observer-polyfill"));

  function _getRequireWildcardCache() {
    if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
      return cache;
    };return cache;
  }

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
      return { "default": obj };
    }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
      return cache.get(obj);
    }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
      if (Object.prototype.hasOwnProperty.call(obj, key)) {
        var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
          Object.defineProperty(newObj, key, desc);
        } else {
          newObj[key] = obj[key];
        }
      }
    }newObj["default"] = obj;if (cache) {
      cache.set(obj, newObj);
    }return newObj;
  }

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _extends() {
    _extends = Object.assign || function (target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i];for (var key in source) {
          if (Object.prototype.hasOwnProperty.call(source, key)) {
            target[key] = source[key];
          }
        }
      }return target;
    };return _extends.apply(this, arguments);
  }

  function ChartWrapper(_ref) {
    var data = _ref.data,
        loading = _ref.loading,
        noDataErrorMessage = _ref.noDataErrorMessage;
    var chart = (0, _react.useRef)();
    var resize = (0, _react.useCallback)(function () {
      return chart.current && chart.current.resize();
    }, [chart]);
    var wrapper = (0, _react.useCallback)(function (node) {
      if (node !== null) {
        new _resizeObserverPolyfill["default"](resize).observe(node);
      }
    }, [resize]);

    if (loading) {
      return _react["default"].createElement("span", {
        "aria-hidden": "true",
        className: "loading-animation"
      });
    } else if (!data.data.columns.length) {
      return _react["default"].createElement("p", null, noDataErrorMessage);
    } else {
      return _react["default"].createElement("div", {
        ref: wrapper
      }, _react["default"].createElement(_charts["default"], _extends({}, data, {
        ref: chart
      })));
    }
  }
  //# sourceMappingURL=ChartWrapper.es.js.map
});
//# sourceMappingURL=ChartWrapper.es.js.map