Liferay.Loader.define("commerce-dashboard-web$billboard.js@1.10.2/src/api/api.x", ['module', 'exports', 'require'], function (module, exports, require) {
	var define = undefined;
	/**
  * Copyright (c) 2017 ~ present NAVER Corp.
  * billboard.js project is licensed under the MIT license
  */
	import Chart from "../internals/Chart";
	import { isArray, isObject, extend } from "../internals/util";

	extend(Chart.prototype, {
		/**
   * Get and set x values for the chart.
   * @method x
   * @instance
   * @memberof Chart
   * @param {Array} x If x is given, x values of every target will be updated. If no argument is given, current x values will be returned as an Object whose keys are the target ids.
   * @return {Object} xs
   * @example
   *  // Get current x values
   *  chart.x();
   *
   *  // Update x values for all targets
   *  chart.x([100, 200, 300, 400, ...]);
   */
		x(x) {
			const $$ = this.internal;
			const isCategorized = $$.isCustomX() && $$.isCategorized();

			if (isArray(x)) {
				if (isCategorized) {
					$$.api.categories(x);
				} else {
					$$.updateTargetX($$.data.targets, x);

					$$.redraw({
						withUpdateOrgXDomain: true,
						withUpdateXDomain: true
					});
				}
			}

			return isCategorized ? $$.api.categories() : $$.data.xs;
		},

		/**
   * Get and set x values for the chart.
   * @method xs
   * @instance
   * @memberof Chart
   * @param {Array} xs If xs is given, specified target's x values will be updated. If no argument is given, current x values will be returned as an Object whose keys are the target ids.
   * @return {Object} xs
   * @example
   *  // Get current x values
   *  chart.xs();
   *
   *  // Update x values for all targets
   *  chart.xs({
   *    data1: [10, 20, 30, 40, ...],
   *    data2: [100, 200, 300, 400, ...]
   *  });
   */
		xs(xs) {
			const $$ = this.internal;

			if (isObject(xs)) {
				$$.updateTargetXs($$.data.targets, xs);

				$$.redraw({
					withUpdateOrgXDomain: true,
					withUpdateXDomain: true
				});
			}

			return $$.data.xs;
		}
	});
});
//# sourceMappingURL=api.x.js.map