Liferay.Loader.define('commerce-dashboard-web$d3-dsv@1.0.10/dist/d3-dsv', ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  // https://d3js.org/d3-dsv/ v1.0.10 Copyright 2018 Mike Bostock
  (function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports) : typeof define === 'function' && define.amd ? define(['exports'], factory) : factory(global.d3 = global.d3 || {});
  })(this, function (exports) {
    'use strict';

    var EOL = {},
        EOF = {},
        QUOTE = 34,
        NEWLINE = 10,
        RETURN = 13;

    function objectConverter(columns) {
      return new Function("d", "return {" + columns.map(function (name, i) {
        return JSON.stringify(name) + ": d[" + i + "]";
      }).join(",") + "}");
    }

    function customConverter(columns, f) {
      var object = objectConverter(columns);
      return function (row, i) {
        return f(object(row), i, columns);
      };
    }

    // Compute unique columns in order of discovery.
    function inferColumns(rows) {
      var columnSet = Object.create(null),
          columns = [];

      rows.forEach(function (row) {
        for (var column in row) {
          if (!(column in columnSet)) {
            columns.push(columnSet[column] = column);
          }
        }
      });

      return columns;
    }

    function dsv(delimiter) {
      var reFormat = new RegExp("[\"" + delimiter + "\n\r]"),
          DELIMITER = delimiter.charCodeAt(0);

      function parseRows(text, f) {
        var rows = [],
            // output rows
        N = text.length,
            I = 0,
            // current character index
        n = 0,
            // current line number
        t,
            // current token
        eof = N <= 0,
            // current token followed by EOF?
        eol = false; // current token followed by EOL?

        // Strip the trailing newline.
        if (text.charCodeAt(N - 1) === NEWLINE) --N;
        if (text.charCodeAt(N - 1) === RETURN) --N;

        function token() {
          if (eof) return EOF;
          if (eol) return eol = false, EOL;

          // Unescape quotes.
          var i,
              j = I,
              c;
          if (text.charCodeAt(j) === QUOTE) {
            while (I++ < N && text.charCodeAt(I) !== QUOTE || text.charCodeAt(++I) === QUOTE);
            if ((i = I) >= N) eof = true;else if ((c = text.charCodeAt(I++)) === NEWLINE) eol = true;else if (c === RETURN) {
              eol = true;if (text.charCodeAt(I) === NEWLINE) ++I;
            }
            return text.slice(j + 1, i - 1).replace(/""/g, "\"");
          }

          // Find next delimiter or newline.
          while (I < N) {
            if ((c = text.charCodeAt(i = I++)) === NEWLINE) eol = true;else if (c === RETURN) {
              eol = true;if (text.charCodeAt(I) === NEWLINE) ++I;
            } else if (c !== DELIMITER) continue;
            return text.slice(j, i);
          }

          // Return last token before EOF.
          return eof = true, text.slice(j, N);
        }

        while ((t = token()) !== EOF) {
          var row = [];
          while (t !== EOL && t !== EOF) row.push(t), t = token();
          if (f && (row = f(row, n++)) == null) continue;
          rows.push(row);
        }

        return rows;
      }

      function formatRow(row) {
        return row.map(formatValue).join(delimiter);
      }

      function formatValue(text) {
        return text == null ? "" : reFormat.test(text += "") ? "\"" + text.replace(/"/g, "\"\"") + "\"" : text;
      }

      return {
        parse: function parse(text, f) {
          var convert,
              columns,
              rows = parseRows(text, function (row, i) {
            if (convert) return convert(row, i - 1);
            columns = row, convert = f ? customConverter(row, f) : objectConverter(row);
          });
          rows.columns = columns || [];
          return rows;
        },
        parseRows: parseRows,
        format: function format(rows, columns) {
          if (columns == null) columns = inferColumns(rows);
          return [columns.map(formatValue).join(delimiter)].concat(rows.map(function (row) {
            return columns.map(function (column) {
              return formatValue(row[column]);
            }).join(delimiter);
          })).join("\n");
        },
        formatRows: function formatRows(rows) {
          return rows.map(formatRow).join("\n");
        }
      };
    }

    var csv = dsv(",");

    var csvParse = csv.parse;
    var csvParseRows = csv.parseRows;
    var csvFormat = csv.format;
    var csvFormatRows = csv.formatRows;

    var tsv = dsv("\t");

    var tsvParse = tsv.parse;
    var tsvParseRows = tsv.parseRows;
    var tsvFormat = tsv.format;
    var tsvFormatRows = tsv.formatRows;

    exports.dsvFormat = dsv;
    exports.csvParse = csvParse;
    exports.csvParseRows = csvParseRows;
    exports.csvFormat = csvFormat;
    exports.csvFormatRows = csvFormatRows;
    exports.tsvParse = tsvParse;
    exports.tsvParseRows = tsvParseRows;
    exports.tsvFormat = tsvFormat;
    exports.tsvFormatRows = tsvFormatRows;

    Object.defineProperty(exports, '__esModule', { value: true });
  });
});
//# sourceMappingURL=d3-dsv.js.map