Liferay.Loader.define("commerce-dashboard-web$d3-geo@1.11.3/src/projection/equalEarth", ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  import projection from "./index.js";
  import { abs, asin, cos, epsilon2, sin, sqrt } from "../math.js";

  var A1 = 1.340264,
      A2 = -0.081106,
      A3 = 0.000893,
      A4 = 0.003796,
      M = sqrt(3) / 2,
      iterations = 12;

  export function equalEarthRaw(lambda, phi) {
    var l = asin(M * sin(phi)),
        l2 = l * l,
        l6 = l2 * l2 * l2;
    return [lambda * cos(l) / (M * (A1 + 3 * A2 * l2 + l6 * (7 * A3 + 9 * A4 * l2))), l * (A1 + A2 * l2 + l6 * (A3 + A4 * l2))];
  }

  equalEarthRaw.invert = function (x, y) {
    var l = y,
        l2 = l * l,
        l6 = l2 * l2 * l2;
    for (var i = 0, delta, fy, fpy; i < iterations; ++i) {
      fy = l * (A1 + A2 * l2 + l6 * (A3 + A4 * l2)) - y;
      fpy = A1 + 3 * A2 * l2 + l6 * (7 * A3 + 9 * A4 * l2);
      l -= delta = fy / fpy, l2 = l * l, l6 = l2 * l2 * l2;
      if (abs(delta) < epsilon2) break;
    }
    return [M * x * (A1 + 3 * A2 * l2 + l6 * (7 * A3 + 9 * A4 * l2)) / cos(l), asin(sin(l) / M)];
  };

  export default function () {
    return projection(equalEarthRaw).scale(177.158);
  }
});
//# sourceMappingURL=equalEarth.js.map