'use strict';

/**
 * Copyright (c) 2013-present, Facebook, Inc.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 */

/**
 * This function is used to mark string literals representing CSS class names
 * so that they can be transformed statically. This allows for modularization
 * and minification of CSS class names.
 *
 * In static_upstream, this function is actually implemented, but it should
 * eventually be replaced with something more descriptive, and the transform
 * that is used in the main stack should be ported for use elsewhere.
 *
 * @param string|object className to modularize, or an object of key/values.
 *                      In the object case, the values are conditions that
 *                      determine if the className keys should be included.
 * @param [string ...]  Variable list of classNames in the string case.
 * @return string       Renderable space-separated CSS className.
 */

Liferay.Loader.define('commerce-dashboard-web$fbjs@0.8.17/lib/cx', ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  function cx(classNames) {
    if (typeof classNames == 'object') {
      return Object.keys(classNames).filter(function (className) {
        return classNames[className];
      }).map(replace).join(' ');
    }
    return Array.prototype.map.call(arguments, replace).join(' ');
  }

  function replace(str) {
    return str.replace(/\//g, '-');
  }

  module.exports = cx;
});
//# sourceMappingURL=cx.js.map