Liferay.Loader.define("commerce-dashboard-web$d3-geo@1.11.3/src/path/area", ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  import adder from "../adder";
  import { abs } from "../math";
  import noop from "../noop";

  var areaSum = adder(),
      areaRingSum = adder(),
      x00,
      y00,
      x0,
      y0;

  var areaStream = {
    point: noop,
    lineStart: noop,
    lineEnd: noop,
    polygonStart: function () {
      areaStream.lineStart = areaRingStart;
      areaStream.lineEnd = areaRingEnd;
    },
    polygonEnd: function () {
      areaStream.lineStart = areaStream.lineEnd = areaStream.point = noop;
      areaSum.add(abs(areaRingSum));
      areaRingSum.reset();
    },
    result: function () {
      areaSum.reset();
      return areaSum / 2;
    }
  };

  function areaRingStart() {
    areaStream.point = areaPointFirst;
  }

  function areaPointFirst(x, y) {
    areaStream.point = areaPoint;
    x00 = x0 = x, y00 = y0 = y;
  }

  function areaPoint(x, y) {
    areaRingSum.add(y0 * x - x0 * y);
    x0 = x, y0 = y;
  }

  function areaRingEnd() {
    areaPoint(x00, y00);
  }

  export default areaStream;
});
//# sourceMappingURL=area.js.map