Liferay.Loader.define("commerce-dashboard-web$d3-transition@1.3.2/src/selection/transition", ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  import { Transition, newId } from "../transition/index.js";
  import schedule from "../transition/schedule.js";
  import { easeCubicInOut } from "d3-ease";
  import { now } from "d3-timer";

  var defaultTiming = {
    time: null, // Set on use.
    delay: 0,
    duration: 250,
    ease: easeCubicInOut
  };

  function inherit(node, id) {
    var timing;
    while (!(timing = node.__transition) || !(timing = timing[id])) {
      if (!(node = node.parentNode)) {
        return defaultTiming.time = now(), defaultTiming;
      }
    }
    return timing;
  }

  export default function (name) {
    var id, timing;

    if (name instanceof Transition) {
      id = name._id, name = name._name;
    } else {
      id = newId(), (timing = defaultTiming).time = now(), name = name == null ? null : name + "";
    }

    for (var groups = this._groups, m = groups.length, j = 0; j < m; ++j) {
      for (var group = groups[j], n = group.length, node, i = 0; i < n; ++i) {
        if (node = group[i]) {
          schedule(node, name, id, i, group, timing || inherit(node, id));
        }
      }
    }

    return new Transition(groups, this._parents, name, id);
  }
});
//# sourceMappingURL=transition.js.map