Liferay.Loader.define("commerce-dashboard-web@1.0.45/js/utils/loadData.es", ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.formatCategoriesForChart = formatCategoriesForChart;
  exports.formatDataForChart = formatDataForChart;
  exports.formatPointForForecast = formatPointForForecast;
  exports.formatPointsForChart = formatPointsForChart;
  exports.getCategoriesArray = getCategoriesArray;
  exports.getDates = getDates;
  exports.getDateString = getDateString;
  exports.getLineTypesForChart = getLineTypesForChart;
  exports.getPoints = getPoints;
  exports.getPredictionDate = getPredictionDate;
  exports.hasNoActualNorForecastValue = hasNoActualNorForecastValue;
  exports.getValuesForCategory = getValuesForCategory;
  exports.isPartOfCategory = isPartOfCategory;
  exports.loadData = loadData;
  exports.parseData = parseData;
  exports.NULL_VALUE = void 0;

  function _slicedToArray(arr, i) {
    return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
  }

  function _nonIterableRest() {
    throw new TypeError("Invalid attempt to destructure non-iterable instance");
  }

  function _iterableToArrayLimit(arr, i) {
    var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
      for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
        _arr.push(_s.value);if (i && _arr.length === i) break;
      }
    } catch (err) {
      _d = true;_e = err;
    } finally {
      try {
        if (!_n && _i["return"] != null) _i["return"]();
      } finally {
        if (_d) throw _e;
      }
    }return _arr;
  }

  function _arrayWithHoles(arr) {
    if (Array.isArray(arr)) return arr;
  }

  function _toConsumableArray(arr) {
    return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread();
  }

  function _nonIterableSpread() {
    throw new TypeError("Invalid attempt to spread non-iterable instance");
  }

  function _iterableToArray(iter) {
    if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter);
  }

  function _arrayWithoutHoles(arr) {
    if (Array.isArray(arr)) {
      for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) {
        arr2[i] = arr[i];
      }return arr2;
    }
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  /**
   * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
   *
   * This library is free software; you can redistribute it and/or modify it under
   * the terms of the GNU Lesser General Public License as published by the Free
   * Software Foundation; either version 2.1 of the License, or (at your option)
   * any later version.
   *
   * This library is distributed in the hope that it will be useful, but WITHOUT
   * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
   * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
   * details.
   */

  /* eslint-disable require-jsdoc */
  var NULL_VALUE = 1.4e-45;
  exports.NULL_VALUE = NULL_VALUE;
  var headers = {
    'Content-Type': 'application/json'
  };

  function byDate(a, b) {
    return new Date(a.timestamp) - new Date(b.timestamp);
  }

  function byName(a, b) {
    return a.name.localeCompare(b.name);
  }

  function formatCategoriesForChart(categories) {
    return categories.reduce(function (a, c) {
      return Object.assign(a, _defineProperty({}, "".concat(c.id), c.name));
    }, {});
  }

  function formatDataForChart() {
    var points = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [];
    var categories = getCategoriesArray(points);
    return {
      axis: {
        x: {
          type: 'timeseries'
        }
      },
      data: {
        columns: formatPointsForChart(points, categories),
        names: formatCategoriesForChart(categories),
        type: 'predictive',
        types: getLineTypesForChart(categories),
        x: 'x'
      },
      predictionDate: getPredictionDate(points)
    };
  }

  function formatPointForForecast(point) {
    return point.actual !== NULL_VALUE ? point.actual : {
      high: point.forecastUpperBound,
      low: point.forecastLowerBound,
      mid: point.forecast
    };
  }

  function formatPointsForChart(points, categories) {
    return !points.length ? [] : [['x'].concat(_toConsumableArray(getDates(points)))].concat(_toConsumableArray(categories.map(function (c) {
      return ["".concat(c.id)].concat(_toConsumableArray(getValuesForCategory(points, c)));
    })));
  }

  function getCategoriesArray() {
    var items = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [];
    return _toConsumableArray(items.reduce(function (a, c) {
      a.set(c.category, c.categoryTitle);
      return a;
    }, new Map()).entries()).map(function (_ref) {
      var _ref2 = _slicedToArray(_ref, 2),
          id = _ref2[0],
          name = _ref2[1];

      return {
        id: id,
        name: name
      };
    }).sort(byName);
  }

  function getDates(points) {
    return points.filter(isPartOfCategory(points[0].category)).map(function (d) {
      return getDateString(d.timestamp);
    });
  }

  function getDateString(ts) {
    return (ts || '').slice(0, 10);
  }

  function getLineTypesForChart(categories) {
    return categories.reduce(function (a, c) {
      return Object.assign(a, _defineProperty({}, "".concat(c.id), 'area-line-range'));
    }, {});
  }

  function getPoints(_ref3) {
    var items = _ref3.items;
    return items;
  }

  function getPredictionDate(points) {
    return !points.length ? null : getDateString(points.slice().reverse().find(function (d) {
      return d.actual !== NULL_VALUE;
    }).timestamp);
  }

  function hasNoActualNorForecastValue(_ref4) {
    var actual = _ref4.actual,
        forecast = _ref4.forecast;
    return !(actual === NULL_VALUE && forecast === NULL_VALUE);
  }

  function getValuesForCategory(points, category) {
    return points.filter(isPartOfCategory(category.id)).filter(hasNoActualNorForecastValue).map(formatPointForForecast);
  }

  function isPartOfCategory(id) {
    return function (_ref5) {
      var category = _ref5.category;
      return category === id;
    };
  }

  function loadData(url) {
    return parseData(fetch("".concat(url, "&p_auth=").concat(window.Liferay.authToken), {
      credentials: 'include',
      headers: headers
    }).then(responseToJson));
  }

  function parseData(loadData) {
    return loadData.then(getPoints).then(sortPointsByDate).then(formatDataForChart);
  }

  function responseToJson(response) {
    return response.json();
  }

  function sortPointsByDate() {
    var points = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [];
    return points.sort(byDate);
  }
  //# sourceMappingURL=loadData.es.js.map
});
//# sourceMappingURL=loadData.es.js.map