Liferay.Loader.define('commerce-dashboard-web$lodash-es@4.17.15/sortedLastIndexOf', ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  import baseSortedIndex from './_baseSortedIndex.js';
  import eq from './eq.js';

  /**
   * This method is like `_.lastIndexOf` except that it performs a binary
   * search on a sorted `array`.
   *
   * @static
   * @memberOf _
   * @since 4.0.0
   * @category Array
   * @param {Array} array The array to inspect.
   * @param {*} value The value to search for.
   * @returns {number} Returns the index of the matched value, else `-1`.
   * @example
   *
   * _.sortedLastIndexOf([4, 5, 5, 5, 6], 5);
   * // => 3
   */
  function sortedLastIndexOf(array, value) {
    var length = array == null ? 0 : array.length;
    if (length) {
      var index = baseSortedIndex(array, value, true) - 1;
      if (eq(array[index], value)) {
        return index;
      }
    }
    return -1;
  }

  export default sortedLastIndexOf;
});
//# sourceMappingURL=sortedLastIndexOf.js.map