Liferay.Loader.define("commerce-dashboard-web$d3-quadtree@1.0.6/src/cover", ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  export default function (x, y) {
    if (isNaN(x = +x) || isNaN(y = +y)) return this; // ignore invalid points

    var x0 = this._x0,
        y0 = this._y0,
        x1 = this._x1,
        y1 = this._y1;

    // If the quadtree has no extent, initialize them.
    // Integer extent are necessary so that if we later double the extent,
    // the existing quadrant boundaries don’t change due to floating point error!
    if (isNaN(x0)) {
      x1 = (x0 = Math.floor(x)) + 1;
      y1 = (y0 = Math.floor(y)) + 1;
    }

    // Otherwise, double repeatedly to cover.
    else {
        var z = x1 - x0,
            node = this._root,
            parent,
            i;

        while (x0 > x || x >= x1 || y0 > y || y >= y1) {
          i = (y < y0) << 1 | x < x0;
          parent = new Array(4), parent[i] = node, node = parent, z *= 2;
          switch (i) {
            case 0:
              x1 = x0 + z, y1 = y0 + z;break;
            case 1:
              x0 = x1 - z, y1 = y0 + z;break;
            case 2:
              x1 = x0 + z, y0 = y1 - z;break;
            case 3:
              x0 = x1 - z, y0 = y1 - z;break;
          }
        }

        if (this._root && this._root.length) this._root = node;
      }

    this._x0 = x0;
    this._y0 = y0;
    this._x1 = x1;
    this._y1 = y1;
    return this;
  }
});
//# sourceMappingURL=cover.js.map