Liferay.Loader.define("commerce-dashboard-web@1.0.38/js/utils/test/loadData", ['module', 'exports', 'require', '../loadData.es', '../mock/data'], function (module, exports, require) {
  var define = undefined;
  var _loadData = require("../loadData.es");

  var _data = require("../mock/data");

  /**
   * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
   *
   * This library is free software; you can redistribute it and/or modify it under
   * the terms of the GNU Lesser General Public License as published by the Free
   * Software Foundation; either version 2.1 of the License, or (at your option)
   * any later version.
   *
   * This library is distributed in the hope that it will be useful, but WITHOUT
   * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
   * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
   * details.
   */
  const categoriesSubset = (0, _loadData.getCategoriesArray)(_data.simpleInput.items);

  const loadData = data => new Promise(resolve => resolve(data));

  describe('Chart loadData utils', () => {
    it('Format categories for chart', () => {
      expect((0, _loadData.formatCategoriesForChart)(categoriesSubset)).toEqual({
        1: 'Cat 1',
        2: 'Cat 2'
      });
    });
    it('Format point for forecast', () => {
      const pastItem = _data.simpleInput.items.find(i => i.actual !== 1.4e-45);

      const futureItem = _data.simpleInput.items.find(i => i.actual === 1.4e-45);

      expect((0, _loadData.formatPointForForecast)(pastItem)).toBe(pastItem.actual);
      expect((0, _loadData.formatPointForForecast)(futureItem)).toEqual({
        high: futureItem.forecastUpperBound,
        low: futureItem.forecastLowerBound,
        mid: futureItem.forecast
      });
    });
    it('Format points for chart', () => {
      expect((0, _loadData.formatPointsForChart)(_data.simpleInput.items, categoriesSubset)).toEqual([['x', '2019-04-01', '2019-05-01'], ['1', 15, {
        high: 18,
        low: 12,
        mid: 16
      }], ['2', 25, {
        high: 28,
        low: 22,
        mid: 26
      }]]);
      expect((0, _loadData.formatPointsForChart)([], [])).toEqual([]);
    });
    it('Get categories array', () => {
      expect((0, _loadData.getCategoriesArray)(_data.simpleInput.items)).toEqual([{
        id: 1,
        name: 'Cat 1'
      }, {
        id: 2,
        name: 'Cat 2'
      }]);
    });
    it('Get dates list', () => {
      expect((0, _loadData.getDates)(_data.simpleInput.items)).toEqual(['2019-04-01', '2019-05-01']);
    });
    it('Convert date to string', () => {
      expect((0, _loadData.getDateString)('2019-07-01T00:00:00Z')).toBe('2019-07-01');
      expect((0, _loadData.getDateString)('')).toBe('');
      expect((0, _loadData.getDateString)(undefined)).toBe('');
    });
    it('Get line types for chart', () => {
      expect((0, _loadData.getLineTypesForChart)(categoriesSubset)).toEqual({
        1: 'area-line-range',
        2: 'area-line-range'
      });
    });
    it('Extract points from data object', () => {
      expect((0, _loadData.getPoints)(_data.simpleInput)).toEqual(_data.simpleInput.items);
    });
    it('Find the prediction date', () => {
      expect((0, _loadData.getPredictionDate)(_data.input.items)).toBe('2019-11-01');
      expect((0, _loadData.getPredictionDate)(_data.simpleInput.items)).toBe('2019-04-01');
    });
    it('Get values for a category', () => {
      expect((0, _loadData.getValuesForCategory)(_data.simpleInput.items, {
        id: 1
      })).toEqual([15, {
        high: 18,
        low: 12,
        mid: 16
      }]);
    });
    it('Is part of a category', () => {
      expect((0, _loadData.isPartOfCategory)(1)({
        category: 1
      })).toBe(true);
      expect((0, _loadData.isPartOfCategory)(1)({
        category: 2
      })).toBe(false);
      expect((0, _loadData.isPartOfCategory)(2)({
        category: 1
      })).toBe(false);
    });
    it('Filters out points whose actual AND forecast values are NULL', () => {
      const invalidSample = {
        actual: _loadData.NULL_VALUE,
        forecast: _loadData.NULL_VALUE
      },
            validSample = {
        actual: 1232,
        forecast: _loadData.NULL_VALUE
      };
      const result = [invalidSample, validSample].filter(_loadData.hasNoActualNorForecastValue);
      expect(result).toEqual([validSample]);
    });
    it('Parse data', () => {
      return (0, _loadData.parseData)(loadData(_data.input)).then(data => {
        expect(data).toEqual(_data.output);
      });
    });
    it('Parse simple data', () => {
      return (0, _loadData.parseData)(loadData(_data.simpleInput)).then(data => {
        expect(data).toEqual(_data.simpleOutput);
      });
    });
  });
  //# sourceMappingURL=loadData.js.map
});
//# sourceMappingURL=loadData.js.map