Liferay.Loader.define("commerce-dashboard-web$d3-shape@1.3.7/src/curve/step", ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  function Step(context, t) {
    this._context = context;
    this._t = t;
  }

  Step.prototype = {
    areaStart: function () {
      this._line = 0;
    },
    areaEnd: function () {
      this._line = NaN;
    },
    lineStart: function () {
      this._x = this._y = NaN;
      this._point = 0;
    },
    lineEnd: function () {
      if (0 < this._t && this._t < 1 && this._point === 2) this._context.lineTo(this._x, this._y);
      if (this._line || this._line !== 0 && this._point === 1) this._context.closePath();
      if (this._line >= 0) this._t = 1 - this._t, this._line = 1 - this._line;
    },
    point: function (x, y) {
      x = +x, y = +y;
      switch (this._point) {
        case 0:
          this._point = 1;this._line ? this._context.lineTo(x, y) : this._context.moveTo(x, y);break;
        case 1:
          this._point = 2; // proceed
        default:
          {
            if (this._t <= 0) {
              this._context.lineTo(this._x, y);
              this._context.lineTo(x, y);
            } else {
              var x1 = this._x * (1 - this._t) + x * this._t;
              this._context.lineTo(x1, this._y);
              this._context.lineTo(x1, y);
            }
            break;
          }
      }
      this._x = x, this._y = y;
    }
  };

  export default function (context) {
    return new Step(context, 0.5);
  }

  export function stepBefore(context) {
    return new Step(context, 0);
  }

  export function stepAfter(context) {
    return new Step(context, 1);
  }
});
//# sourceMappingURL=step.js.map