Liferay.Loader.define("commerce-dashboard-web$d3-ease@1.0.6/src/elastic", ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  var tau = 2 * Math.PI,
      amplitude = 1,
      period = 0.3;

  export var elasticIn = function custom(a, p) {
    var s = Math.asin(1 / (a = Math.max(1, a))) * (p /= tau);

    function elasticIn(t) {
      return a * Math.pow(2, 10 * --t) * Math.sin((s - t) / p);
    }

    elasticIn.amplitude = function (a) {
      return custom(a, p * tau);
    };
    elasticIn.period = function (p) {
      return custom(a, p);
    };

    return elasticIn;
  }(amplitude, period);

  export var elasticOut = function custom(a, p) {
    var s = Math.asin(1 / (a = Math.max(1, a))) * (p /= tau);

    function elasticOut(t) {
      return 1 - a * Math.pow(2, -10 * (t = +t)) * Math.sin((t + s) / p);
    }

    elasticOut.amplitude = function (a) {
      return custom(a, p * tau);
    };
    elasticOut.period = function (p) {
      return custom(a, p);
    };

    return elasticOut;
  }(amplitude, period);

  export var elasticInOut = function custom(a, p) {
    var s = Math.asin(1 / (a = Math.max(1, a))) * (p /= tau);

    function elasticInOut(t) {
      return ((t = t * 2 - 1) < 0 ? a * Math.pow(2, 10 * t) * Math.sin((s - t) / p) : 2 - a * Math.pow(2, -10 * t) * Math.sin((s + t) / p)) / 2;
    }

    elasticInOut.amplitude = function (a) {
      return custom(a, p * tau);
    };
    elasticInOut.period = function (p) {
      return custom(a, p);
    };

    return elasticInOut;
  }(amplitude, period);
});
//# sourceMappingURL=elastic.js.map