/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.account.test.util;

import com.liferay.account.model.AccountEntry;
import com.liferay.account.model.AccountGroup;
import com.liferay.account.service.AccountEntryLocalServiceUtil;
import com.liferay.account.service.AccountEntryOrganizationRelLocalServiceUtil;
import com.liferay.account.service.AccountEntryUserRelLocalServiceUtil;
import com.liferay.account.service.AccountGroupLocalServiceUtil;
import com.liferay.account.service.AccountGroupRelLocalServiceUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.RoleLocalServiceUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserGroupRoleLocalServiceUtil;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.test.randomizerbumpers.RandomizerBumper;
import com.liferay.portal.kernel.test.util.RandomTestUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.Validator;

public class CommerceAccountTestUtil {
    public static void addAccountEntryOrganizationRels(long accountEntryId, long[] organizationIds, ServiceContext serviceContext) throws PortalException {
        AccountEntryOrganizationRelLocalServiceUtil.addAccountEntryOrganizationRels((long)accountEntryId, (long[])organizationIds);
    }

    public static void addAccountEntryUserRels(long accountEntryId, long[] userIds, ServiceContext serviceContext) throws PortalException {
        if (userIds != null) {
            for (long userId : userIds) {
                User user = UserLocalServiceUtil.getUser((long)userId);
                AccountEntryUserRelLocalServiceUtil.addAccountEntryUserRel((long)accountEntryId, (long)user.getUserId());
                AccountEntry accountEntry = AccountEntryLocalServiceUtil.getAccountEntry((long)accountEntryId);
                if (!ArrayUtil.contains((long[])user.getGroupIds(), (long)accountEntry.getAccountEntryGroupId())) {
                    UserLocalServiceUtil.addGroupUsers((long)accountEntry.getAccountEntryGroupId(), (long[])new long[]{userId});
                }
                if (ArrayUtil.contains((long[])user.getGroupIds(), (long)serviceContext.getScopeGroupId())) continue;
                UserLocalServiceUtil.addGroupUsers((long)serviceContext.getScopeGroupId(), (long[])new long[]{userId});
            }
        }
    }

    public static AccountGroup addAccountGroup(long companyId, String name, String type, String externalReferenceCode, ServiceContext serviceContext) throws PortalException {
        if (Validator.isBlank((String)externalReferenceCode)) {
            externalReferenceCode = null;
        }
        AccountGroup accountGroup = AccountGroupLocalServiceUtil.addAccountGroup((long)serviceContext.getUserId(), null, (String)name, (ServiceContext)serviceContext);
        accountGroup.setExternalReferenceCode(externalReferenceCode);
        accountGroup.setDefaultAccountGroup(false);
        accountGroup.setType(type);
        accountGroup.setExpandoBridgeAttributes(serviceContext);
        return AccountGroupLocalServiceUtil.updateAccountGroup((AccountGroup)accountGroup);
    }

    public static AccountGroup addAccountGroupAndAccountRel(long companyId, String name, String type, long accountGroupId, ServiceContext serviceContext) throws PortalException {
        AccountGroup accountGroup = CommerceAccountTestUtil.addAccountGroup(companyId, name, type, RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]), serviceContext);
        AccountGroupRelLocalServiceUtil.addAccountGroupRel((long)accountGroup.getAccountGroupId(), (String)AccountEntry.class.getName(), (long)accountGroupId);
        return accountGroup;
    }

    public static AccountEntry addBusinessAccountEntry(long userId, String name, String email, ServiceContext serviceContext) throws Exception {
        return CommerceAccountTestUtil.addBusinessAccountEntry(userId, name, email, "", null, null, serviceContext);
    }

    public static AccountEntry addBusinessAccountEntry(long userId, String name, String email, String externalReferenceCode, long[] userIds, long[] organizationIds, ServiceContext serviceContext) throws Exception {
        AccountEntry accountEntry = AccountEntryLocalServiceUtil.addAccountEntry((long)userId, (long)0L, (String)name, null, null, (String)email, null, (String)"", (String)"business", (int)0, (ServiceContext)serviceContext);
        CommerceAccountTestUtil.addAccountEntryUserRels(accountEntry.getAccountEntryId(), new long[]{userId}, serviceContext);
        Role role = RoleLocalServiceUtil.getRole((long)serviceContext.getCompanyId(), (String)"Account Administrator");
        UserGroupRoleLocalServiceUtil.addUserGroupRoles((long)userId, (long)accountEntry.getAccountEntryGroupId(), (long[])new long[]{role.getRoleId()});
        if (externalReferenceCode != null) {
            accountEntry.setExternalReferenceCode(externalReferenceCode);
            accountEntry = AccountEntryLocalServiceUtil.updateAccountEntry((AccountEntry)accountEntry);
        }
        CommerceAccountTestUtil.addAccountEntryUserRels(accountEntry.getAccountEntryId(), userIds, serviceContext);
        CommerceAccountTestUtil.addAccountEntryOrganizationRels(accountEntry.getAccountEntryId(), organizationIds, serviceContext);
        return accountEntry;
    }

    public static AccountEntry addBusinessAccountEntry(long userId, String name, String email, String externalReferenceCode, ServiceContext serviceContext) throws Exception {
        return CommerceAccountTestUtil.addBusinessAccountEntry(userId, name, email, externalReferenceCode, null, null, serviceContext);
    }

    public static AccountEntry addPersonAccountEntry(long userId, ServiceContext serviceContext) throws Exception {
        User user = UserLocalServiceUtil.getUser((long)userId);
        serviceContext.setCompanyId(user.getCompanyId());
        serviceContext.setUserId(userId);
        AccountEntry accountEntry = AccountEntryLocalServiceUtil.addAccountEntry((long)userId, (long)0L, (String)user.getFullName(), null, null, (String)user.getEmailAddress(), null, (String)"", (String)"person", (int)0, (ServiceContext)serviceContext);
        AccountEntryUserRelLocalServiceUtil.addAccountEntryUserRel((long)accountEntry.getAccountEntryId(), (long)userId);
        return accountEntry;
    }

    public static AccountEntry getPersonAccountEntry(long userId) throws Exception {
        AccountEntry accountEntry = AccountEntryLocalServiceUtil.fetchPersonAccountEntry((long)userId);
        if (accountEntry != null) {
            return accountEntry;
        }
        return CommerceAccountTestUtil.addPersonAccountEntry(userId, new ServiceContext());
    }
}

