<%--
/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */
--%>

<%@ include file="/init.jsp" %>

<%
CommerceAccountGroupAdminDisplayContext commerceAccountGroupAdminDisplayContext = (CommerceAccountGroupAdminDisplayContext)request.getAttribute(WebKeys.PORTLET_DISPLAY_CONTEXT);

CommerceAccountGroup commerceAccountGroup = commerceAccountGroupAdminDisplayContext.getCommerceAccountGroup();
long commerceAccountGroupId = commerceAccountGroupAdminDisplayContext.getCommerceAccountGroupId();
%>

<portlet:actionURL name="editCommerceAccountGroup" var="editCommerceAccountGroupActionURL" />

<aui:form action="<%= editCommerceAccountGroupActionURL %>" cssClass="container-fluid-1280" method="post" name="fm">
	<aui:input name="<%= Constants.CMD %>" type="hidden" value="<%= (commerceAccountGroup == null) ? Constants.ADD : Constants.UPDATE %>" />
	<aui:input name="redirect" type="hidden" value="<%= currentURL %>" />
	<aui:input name="backURL" type="hidden" value="<%= backURL %>" />
	<aui:input name="commerceAccountGroupId" type="hidden" value="<%= commerceAccountGroupId %>" />

	<aui:model-context bean="<%= commerceAccountGroup %>" model="<%= CommerceAccountGroup.class %>" />

	<liferay-ui:error exception="<%= CommerceAccountGroupNameException.class %>" message="please-enter-a-valid-name" />

	<div class="lfr-form-content">
		<aui:fieldset-group markupView="lexicon">
			<aui:fieldset>
				<aui:input autoFocus="<%= true %>" disabled="<%= (commerceAccountGroup != null) && commerceAccountGroup.isSystem() %>" name="name" />
			</aui:fieldset>

			<c:if test="<%= commerceAccountGroupAdminDisplayContext.hasCustomAttributesAvailable() %>">
				<aui:fieldset collapsible="<%= true %>" label="custom-attribute">
					<liferay-expando:custom-attribute-list
						className="<%= CommerceAccountGroup.class.getName() %>"
						classPK="<%= commerceAccountGroupId %>"
						editable="<%= true %>"
						label="<%= true %>"
					/>
				</aui:fieldset>
			</c:if>

			<aui:fieldset>
				<aui:button-row>
					<c:if test="<%= (commerceAccountGroup == null) || !commerceAccountGroup.isSystem() %>">
						<aui:button cssClass="btn-lg" type="submit" value="save" />
					</c:if>

					<aui:button cssClass="btn-lg" href="<%= backURL %>" type="cancel" />
				</aui:button-row>
			</aui:fieldset>
		</aui:fieldset-group>
	</div>
</aui:form>