/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.account.group.admin.web.internal.portlet.action;

import com.liferay.commerce.account.exception.CommerceAccountGroupNameException;
import com.liferay.commerce.account.exception.NoSuchAccountGroupException;
import com.liferay.commerce.account.model.CommerceAccountGroup;
import com.liferay.commerce.account.service.CommerceAccountGroupService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.bridges.mvc.BaseMVCActionCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_commerce_account_group_admin_web_internal_portlet_CommerceAccountGroupAdminPortlet", "mvc.command.name=editCommerceAccountGroup"}, service={MVCActionCommand.class})
public class EditCommerceAccountGroupMVCActionCommand
extends BaseMVCActionCommand {
    private static final Log _log = LogFactoryUtil.getLog(EditCommerceAccountGroupMVCActionCommand.class);
    @Reference
    private CommerceAccountGroupService _commerceAccountGroupService;
    @Reference
    private Portal _portal;

    protected void deleteCommerceAccountGroups(ActionRequest actionRequest) throws PortalException {
        long[] deleteCommerceAccountGroupIds = null;
        long commerceAccountGroupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"commerceAccountGroupId");
        deleteCommerceAccountGroupIds = commerceAccountGroupId > 0L ? new long[]{commerceAccountGroupId} : StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"deleteCommerceAccountGroupIds"), (long)0L);
        for (long deleteCommerceAccountGroupId : deleteCommerceAccountGroupIds) {
            this._commerceAccountGroupService.deleteCommerceAccountGroup(deleteCommerceAccountGroupId);
        }
    }

    protected void doProcessAction(ActionRequest actionRequest, ActionResponse actionResponse) {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            if (cmd.equals("add") || cmd.equals("update")) {
                CommerceAccountGroup commerceAccountGroup = this.updateCommerceAccountGroup(actionRequest);
                String redirect = this.getSaveAndContinueRedirect(actionRequest, commerceAccountGroup);
                this.sendRedirect(actionRequest, actionResponse, redirect);
            } else if (cmd.equals("delete")) {
                this.deleteCommerceAccountGroups(actionRequest);
            }
        }
        catch (Exception e) {
            if (e instanceof CommerceAccountGroupNameException) {
                this.hideDefaultErrorMessage((PortletRequest)actionRequest);
                SessionErrors.add((PortletRequest)actionRequest, e.getClass());
                actionResponse.setRenderParameter("mvcRenderCommandName", "editCommerceAccountGroup");
            }
            if (e instanceof NoSuchAccountGroupException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass());
                actionResponse.setRenderParameter("mvcPath", "/error.jsp");
            }
            _log.error((Object)e, (Throwable)e);
        }
    }

    protected String getSaveAndContinueRedirect(ActionRequest actionRequest, CommerceAccountGroup commerceAccountGroup) {
        PortletURL portletURL = this._portal.getControlPanelPortletURL((PortletRequest)actionRequest, "com_liferay_commerce_account_group_admin_web_internal_portlet_CommerceAccountGroupAdminPortlet", "RENDER_PHASE");
        if (commerceAccountGroup != null) {
            portletURL.setParameter("mvcRenderCommandName", "editCommerceAccountGroup");
            portletURL.setParameter("commerceAccountGroupId", String.valueOf(commerceAccountGroup.getCommerceAccountGroupId()));
            String redirect = ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect");
            portletURL.setParameter("redirect", redirect);
            String backURL = ParamUtil.getString((PortletRequest)actionRequest, (String)"backURL", (String)redirect);
            portletURL.setParameter("backURL", backURL);
        }
        return portletURL.toString();
    }

    protected CommerceAccountGroup updateCommerceAccountGroup(ActionRequest actionRequest) throws Exception {
        long commerceAccountGroupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"commerceAccountGroupId");
        String name = ParamUtil.getString((PortletRequest)actionRequest, (String)"name");
        int type = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"type", (int)0);
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)CommerceAccountGroup.class.getName(), (PortletRequest)actionRequest);
        CommerceAccountGroup commerceAccountGroup = null;
        commerceAccountGroup = commerceAccountGroupId <= 0L ? this._commerceAccountGroupService.addCommerceAccountGroup(this._portal.getCompanyId((PortletRequest)actionRequest), name, type, null, serviceContext) : this._commerceAccountGroupService.updateCommerceAccountGroup(commerceAccountGroupId, name, serviceContext);
        return commerceAccountGroup;
    }
}

