/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.commerce.account.model;

import aQute.bnd.annotation.ProviderType;

import com.liferay.commerce.account.service.persistence.CommerceAccountOrganizationRelPK;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.kernel.model.AuditedModel;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ShardedModel;
import com.liferay.portal.kernel.service.ServiceContext;

import java.io.Serializable;

import java.util.Date;

/**
 * The base model interface for the CommerceAccountOrganizationRel service. Represents a row in the &quot;CommerceAccountOrganizationRel&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation <code>com.liferay.commerce.account.model.impl.CommerceAccountOrganizationRelModelImpl</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in <code>com.liferay.commerce.account.model.impl.CommerceAccountOrganizationRelImpl</code>.
 * </p>
 *
 * @author Marco Leo
 * @see CommerceAccountOrganizationRel
 * @generated
 */
@ProviderType
public interface CommerceAccountOrganizationRelModel
	extends AuditedModel, BaseModel<CommerceAccountOrganizationRel>,
			ShardedModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this interface directly. All methods that expect a commerce account organization rel model instance should use the {@link CommerceAccountOrganizationRel} interface instead.
	 */

	/**
	 * Returns the primary key of this commerce account organization rel.
	 *
	 * @return the primary key of this commerce account organization rel
	 */
	public CommerceAccountOrganizationRelPK getPrimaryKey();

	/**
	 * Sets the primary key of this commerce account organization rel.
	 *
	 * @param primaryKey the primary key of this commerce account organization rel
	 */
	public void setPrimaryKey(CommerceAccountOrganizationRelPK primaryKey);

	/**
	 * Returns the commerce account ID of this commerce account organization rel.
	 *
	 * @return the commerce account ID of this commerce account organization rel
	 */
	public long getCommerceAccountId();

	/**
	 * Sets the commerce account ID of this commerce account organization rel.
	 *
	 * @param commerceAccountId the commerce account ID of this commerce account organization rel
	 */
	public void setCommerceAccountId(long commerceAccountId);

	/**
	 * Returns the organization ID of this commerce account organization rel.
	 *
	 * @return the organization ID of this commerce account organization rel
	 */
	public long getOrganizationId();

	/**
	 * Sets the organization ID of this commerce account organization rel.
	 *
	 * @param organizationId the organization ID of this commerce account organization rel
	 */
	public void setOrganizationId(long organizationId);

	/**
	 * Returns the company ID of this commerce account organization rel.
	 *
	 * @return the company ID of this commerce account organization rel
	 */
	@Override
	public long getCompanyId();

	/**
	 * Sets the company ID of this commerce account organization rel.
	 *
	 * @param companyId the company ID of this commerce account organization rel
	 */
	@Override
	public void setCompanyId(long companyId);

	/**
	 * Returns the user ID of this commerce account organization rel.
	 *
	 * @return the user ID of this commerce account organization rel
	 */
	@Override
	public long getUserId();

	/**
	 * Sets the user ID of this commerce account organization rel.
	 *
	 * @param userId the user ID of this commerce account organization rel
	 */
	@Override
	public void setUserId(long userId);

	/**
	 * Returns the user uuid of this commerce account organization rel.
	 *
	 * @return the user uuid of this commerce account organization rel
	 */
	@Override
	public String getUserUuid();

	/**
	 * Sets the user uuid of this commerce account organization rel.
	 *
	 * @param userUuid the user uuid of this commerce account organization rel
	 */
	@Override
	public void setUserUuid(String userUuid);

	/**
	 * Returns the user name of this commerce account organization rel.
	 *
	 * @return the user name of this commerce account organization rel
	 */
	@AutoEscape
	@Override
	public String getUserName();

	/**
	 * Sets the user name of this commerce account organization rel.
	 *
	 * @param userName the user name of this commerce account organization rel
	 */
	@Override
	public void setUserName(String userName);

	/**
	 * Returns the create date of this commerce account organization rel.
	 *
	 * @return the create date of this commerce account organization rel
	 */
	@Override
	public Date getCreateDate();

	/**
	 * Sets the create date of this commerce account organization rel.
	 *
	 * @param createDate the create date of this commerce account organization rel
	 */
	@Override
	public void setCreateDate(Date createDate);

	/**
	 * Returns the modified date of this commerce account organization rel.
	 *
	 * @return the modified date of this commerce account organization rel
	 */
	@Override
	public Date getModifiedDate();

	/**
	 * Sets the modified date of this commerce account organization rel.
	 *
	 * @param modifiedDate the modified date of this commerce account organization rel
	 */
	@Override
	public void setModifiedDate(Date modifiedDate);

	@Override
	public boolean isNew();

	@Override
	public void setNew(boolean n);

	@Override
	public boolean isCachedModel();

	@Override
	public void setCachedModel(boolean cachedModel);

	@Override
	public boolean isEscapedModel();

	@Override
	public Serializable getPrimaryKeyObj();

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj);

	@Override
	public ExpandoBridge getExpandoBridge();

	@Override
	public void setExpandoBridgeAttributes(BaseModel<?> baseModel);

	@Override
	public void setExpandoBridgeAttributes(ExpandoBridge expandoBridge);

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext);

	@Override
	public Object clone();

	@Override
	public int compareTo(
		CommerceAccountOrganizationRel commerceAccountOrganizationRel);

	@Override
	public int hashCode();

	@Override
	public CacheModel<CommerceAccountOrganizationRel> toCacheModel();

	@Override
	public CommerceAccountOrganizationRel toEscapedModel();

	@Override
	public CommerceAccountOrganizationRel toUnescapedModel();

	@Override
	public String toString();

	@Override
	public String toXmlString();

}