/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.commerce.account.configuration;

import aQute.bnd.annotation.metatype.Meta;

import com.liferay.commerce.account.constants.CommerceAccountConstants;
import com.liferay.portal.configuration.metatype.annotations.ExtendedObjectClassDefinition;

/**
 * @author Alessio Antonio Rendina
 */
@ExtendedObjectClassDefinition(
	category = "orders", scope = ExtendedObjectClassDefinition.Scope.GROUP
)
@Meta.OCD(
	id = "com.liferay.commerce.account.configuration.CommerceAccountGroupServiceConfiguration",
	localization = "content/Language",
	name = "commerce-account-group-service-configuration-name"
)
public interface CommerceAccountGroupServiceConfiguration {

	@Meta.AD(
		deflt = "" + CommerceAccountConstants.SITE_TYPE_B2C,
		name = "commerce-site-type", optionLabels = {"B2C", "B2B", "B2C-B2B"},
		optionValues = {"0", "1", "2"}, required = false
	)
	public int commerceSiteType();

}