/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.account.constants;

public class CommerceAccountConstants {
    public static final String ACCOUNT_GROUP_NAME_GUEST = "Guest";
    public static final int ACCOUNT_GROUP_TYPE_DYNAMIC = 1;
    public static final int ACCOUNT_GROUP_TYPE_GUEST = 2;
    public static final int ACCOUNT_GROUP_TYPE_STATIC = 0;
    public static final int[] ACCOUNT_GROUP_TYPES = new int[]{0, 1};
    public static final long ACCOUNT_ID_ADMIN = Long.MIN_VALUE;
    public static final long ACCOUNT_ID_GUEST = -1L;
    public static final int ACCOUNT_TYPE_BUSINESS = 2;
    public static final int ACCOUNT_TYPE_GUEST = 0;
    public static final int ACCOUNT_TYPE_PERSONAL = 1;
    public static final int[] ACCOUNT_TYPES = new int[]{0, 1, 2};
    public static final long DEFAULT_PARENT_ACCOUNT_ID = 0L;
    public static final String RESOURCE_NAME = "com.liferay.commerce.account";
    public static final String ROLE_NAME_ACCOUNT_ADMINISTRATOR = "Account Administrator";
    public static final String ROLE_NAME_ACCOUNT_BUYER = "Buyer";
    public static final String ROLE_NAME_ACCOUNT_DISCOUNT_MANAGER = "Discount Manager";
    public static final String ROLE_NAME_ACCOUNT_ORDER_MANAGER = "Order Manager";
    public static final String SERVICE_NAME = "com.liferay.commerce.account";
    public static final int SITE_TYPE_B2B = 1;
    public static final int SITE_TYPE_B2C = 0;
    public static final int SITE_TYPE_B2X = 2;
    public static final int[] SITE_TYPES = new int[]{0, 1, 2};

    public static String getAccountGroupTypeLabel(int accountGroupType) {
        if (accountGroupType == 0) {
            return "static";
        }
        if (accountGroupType == 1) {
            return "dynamic";
        }
        return null;
    }

    public static String getAccountTypeLabel(int accountType) {
        if (accountType == 2) {
            return "business";
        }
        if (accountType == 0) {
            return "guest";
        }
        if (accountType == 1) {
            return "personal";
        }
        return null;
    }

    public static String getSiteTypeLabel(int siteType) {
        if (siteType == 0) {
            return "b2c";
        }
        if (siteType == 1) {
            return "b2b";
        }
        if (siteType == 2) {
            return "b2x";
        }
        return null;
    }
}

