/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.commerce.account.service;

import com.liferay.portal.kernel.service.ServiceWrapper;

/**
 * Provides a wrapper for {@link CommerceAccountGroupLocalService}.
 *
 * @author Marco Leo
 * @see CommerceAccountGroupLocalService
 * @generated
 */
public class CommerceAccountGroupLocalServiceWrapper
	implements CommerceAccountGroupLocalService,
			   ServiceWrapper<CommerceAccountGroupLocalService> {

	public CommerceAccountGroupLocalServiceWrapper() {
		this(null);
	}

	public CommerceAccountGroupLocalServiceWrapper(
		CommerceAccountGroupLocalService commerceAccountGroupLocalService) {

		_commerceAccountGroupLocalService = commerceAccountGroupLocalService;
	}

	@Override
	public com.liferay.commerce.account.model.CommerceAccountGroup
			addCommerceAccountGroup(
				long companyId, String name, int type, boolean system,
				String externalReferenceCode,
				com.liferay.portal.kernel.service.ServiceContext serviceContext)
		throws com.liferay.portal.kernel.exception.PortalException {

		return _commerceAccountGroupLocalService.addCommerceAccountGroup(
			companyId, name, type, system, externalReferenceCode,
			serviceContext);
	}

	@Override
	public void checkGuestCommerceAccountGroup(long companyId)
		throws com.liferay.portal.kernel.exception.PortalException {

		_commerceAccountGroupLocalService.checkGuestCommerceAccountGroup(
			companyId);
	}

	@Override
	public com.liferay.commerce.account.model.CommerceAccountGroup
			deleteCommerceAccountGroup(
				com.liferay.commerce.account.model.CommerceAccountGroup
					commerceAccountGroup)
		throws com.liferay.portal.kernel.exception.PortalException {

		return _commerceAccountGroupLocalService.deleteCommerceAccountGroup(
			commerceAccountGroup);
	}

	@Override
	public com.liferay.commerce.account.model.CommerceAccountGroup
			deleteCommerceAccountGroup(long commerceAccountGroupId)
		throws com.liferay.portal.kernel.exception.PortalException {

		return _commerceAccountGroupLocalService.deleteCommerceAccountGroup(
			commerceAccountGroupId);
	}

	@Override
	public com.liferay.commerce.account.model.CommerceAccountGroup
		fetchByExternalReferenceCode(
			long companyId, String externalReferenceCode) {

		return _commerceAccountGroupLocalService.fetchByExternalReferenceCode(
			companyId, externalReferenceCode);
	}

	@Override
	public com.liferay.commerce.account.model.CommerceAccountGroup
		fetchCommerceAccountGroup(long commerceAccountGroupId) {

		return _commerceAccountGroupLocalService.fetchCommerceAccountGroup(
			commerceAccountGroupId);
	}

	@Override
	public com.liferay.commerce.account.model.CommerceAccountGroup
			getCommerceAccountGroup(long commerceAccountGroupId)
		throws com.liferay.portal.kernel.exception.PortalException {

		return _commerceAccountGroupLocalService.getCommerceAccountGroup(
			commerceAccountGroupId);
	}

	@Override
	public java.util.List
		<com.liferay.commerce.account.model.CommerceAccountGroup>
			getCommerceAccountGroups(
				long companyId, int start, int end,
				com.liferay.portal.kernel.util.OrderByComparator
					<com.liferay.commerce.account.model.CommerceAccountGroup>
						orderByComparator) {

		return _commerceAccountGroupLocalService.getCommerceAccountGroups(
			companyId, start, end, orderByComparator);
	}

	@Override
	public java.util.List
		<com.liferay.commerce.account.model.CommerceAccountGroup>
			getCommerceAccountGroupsByCommerceAccountId(
				long commerceAccountId, int start, int end) {

		return _commerceAccountGroupLocalService.
			getCommerceAccountGroupsByCommerceAccountId(
				commerceAccountId, start, end);
	}

	@Override
	public int getCommerceAccountGroupsByCommerceAccountIdCount(
		long commerceAccountId) {

		return _commerceAccountGroupLocalService.
			getCommerceAccountGroupsByCommerceAccountIdCount(commerceAccountId);
	}

	@Override
	public int getCommerceAccountGroupsCount(long companyId) {
		return _commerceAccountGroupLocalService.getCommerceAccountGroupsCount(
			companyId);
	}

	@Override
	public java.util.List<Long> getCommerceAccountUserIdsFromAccountGroupIds(
		long[] commerceAccountGroupIds, int start, int end) {

		return _commerceAccountGroupLocalService.
			getCommerceAccountUserIdsFromAccountGroupIds(
				commerceAccountGroupIds, start, end);
	}

	/**
	 * Returns the OSGi service identifier.
	 *
	 * @return the OSGi service identifier
	 */
	@Override
	public String getOSGiServiceIdentifier() {
		return _commerceAccountGroupLocalService.getOSGiServiceIdentifier();
	}

	@Override
	public java.util.List
		<com.liferay.commerce.account.model.CommerceAccountGroup> search(
				long companyId, String keywords, int start, int end,
				com.liferay.portal.kernel.search.Sort sort)
			throws com.liferay.portal.kernel.exception.PortalException {

		return _commerceAccountGroupLocalService.search(
			companyId, keywords, start, end, sort);
	}

	@Override
	public int searchCommerceAccountsGroupCount(
		long companyId, String keywords) {

		return _commerceAccountGroupLocalService.
			searchCommerceAccountsGroupCount(companyId, keywords);
	}

	@Override
	public com.liferay.commerce.account.model.CommerceAccountGroup
			updateCommerceAccountGroup(
				long commerceAccountGroupId, String name,
				com.liferay.portal.kernel.service.ServiceContext serviceContext)
		throws com.liferay.portal.kernel.exception.PortalException {

		return _commerceAccountGroupLocalService.updateCommerceAccountGroup(
			commerceAccountGroupId, name, serviceContext);
	}

	@Override
	public CommerceAccountGroupLocalService getWrappedService() {
		return _commerceAccountGroupLocalService;
	}

	@Override
	public void setWrappedService(
		CommerceAccountGroupLocalService commerceAccountGroupLocalService) {

		_commerceAccountGroupLocalService = commerceAccountGroupLocalService;
	}

	private CommerceAccountGroupLocalService _commerceAccountGroupLocalService;

}