/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.commerce.account.service.persistence;

import com.liferay.petra.lang.HashUtil;
import com.liferay.petra.string.StringBundler;

import java.io.Serializable;

/**
 * @author Marco Leo
 * @generated
 */
public class CommerceAccountUserRelPK
	implements Comparable<CommerceAccountUserRelPK>, Serializable {

	public long commerceAccountId;
	public long commerceAccountUserId;

	public CommerceAccountUserRelPK() {
	}

	public CommerceAccountUserRelPK(
		long commerceAccountId, long commerceAccountUserId) {

		this.commerceAccountId = commerceAccountId;
		this.commerceAccountUserId = commerceAccountUserId;
	}

	public long getCommerceAccountId() {
		return commerceAccountId;
	}

	public void setCommerceAccountId(long commerceAccountId) {
		this.commerceAccountId = commerceAccountId;
	}

	public long getCommerceAccountUserId() {
		return commerceAccountUserId;
	}

	public void setCommerceAccountUserId(long commerceAccountUserId) {
		this.commerceAccountUserId = commerceAccountUserId;
	}

	@Override
	public int compareTo(CommerceAccountUserRelPK pk) {
		if (pk == null) {
			return -1;
		}

		int value = 0;

		if (commerceAccountId < pk.commerceAccountId) {
			value = -1;
		}
		else if (commerceAccountId > pk.commerceAccountId) {
			value = 1;
		}
		else {
			value = 0;
		}

		if (value != 0) {
			return value;
		}

		if (commerceAccountUserId < pk.commerceAccountUserId) {
			value = -1;
		}
		else if (commerceAccountUserId > pk.commerceAccountUserId) {
			value = 1;
		}
		else {
			value = 0;
		}

		if (value != 0) {
			return value;
		}

		return 0;
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof CommerceAccountUserRelPK)) {
			return false;
		}

		CommerceAccountUserRelPK pk = (CommerceAccountUserRelPK)object;

		if ((commerceAccountId == pk.commerceAccountId) &&
			(commerceAccountUserId == pk.commerceAccountUserId)) {

			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		int hashCode = 0;

		hashCode = HashUtil.hash(hashCode, commerceAccountId);
		hashCode = HashUtil.hash(hashCode, commerceAccountUserId);

		return hashCode;
	}

	@Override
	public String toString() {
		StringBundler sb = new StringBundler(6);

		sb.append("{");

		sb.append("commerceAccountId=");

		sb.append(commerceAccountId);
		sb.append(", commerceAccountUserId=");

		sb.append(commerceAccountUserId);

		sb.append("}");

		return sb.toString();
	}

}