/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.commerce.account.model;

import com.liferay.portal.kernel.annotation.ImplementationClassName;
import com.liferay.portal.kernel.util.Accessor;

import org.osgi.annotation.versioning.ProviderType;

/**
 * The extended model interface for the CommerceAccountUserRel service. Represents a row in the &quot;CommerceAccountUserRel&quot; database table, with each column mapped to a property of this class.
 *
 * @author Marco Leo
 * @see CommerceAccountUserRelModel
 * @generated
 */
@ImplementationClassName(
	"com.liferay.commerce.account.model.impl.CommerceAccountUserRelImpl"
)
@ProviderType
public interface CommerceAccountUserRel extends CommerceAccountUserRelModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify this interface directly. Add methods to <code>com.liferay.commerce.account.model.impl.CommerceAccountUserRelImpl</code> and rerun ServiceBuilder to automatically copy the method declarations to this interface.
	 */
	public static final Accessor<CommerceAccountUserRel, Long>
		COMMERCE_ACCOUNT_ID_ACCESSOR =
			new Accessor<CommerceAccountUserRel, Long>() {

				@Override
				public Long get(CommerceAccountUserRel commerceAccountUserRel) {
					return commerceAccountUserRel.getCommerceAccountId();
				}

				@Override
				public Class<Long> getAttributeClass() {
					return Long.class;
				}

				@Override
				public Class<CommerceAccountUserRel> getTypeClass() {
					return CommerceAccountUserRel.class;
				}

			};
	public static final Accessor<CommerceAccountUserRel, Long>
		COMMERCE_ACCOUNT_USER_ID_ACCESSOR =
			new Accessor<CommerceAccountUserRel, Long>() {

				@Override
				public Long get(CommerceAccountUserRel commerceAccountUserRel) {
					return commerceAccountUserRel.getCommerceAccountUserId();
				}

				@Override
				public Class<Long> getAttributeClass() {
					return Long.class;
				}

				@Override
				public Class<CommerceAccountUserRel> getTypeClass() {
					return CommerceAccountUserRel.class;
				}

			};

	public com.liferay.portal.kernel.model.User getUser()
		throws com.liferay.portal.kernel.exception.PortalException;

	public java.util.List<com.liferay.portal.kernel.model.UserGroupRole>
			getUserGroupRoles()
		throws com.liferay.portal.kernel.exception.PortalException;

}