/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.commerce.account.model;

import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.kernel.model.AuditedModel;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.ShardedModel;

import java.util.Date;

import org.osgi.annotation.versioning.ProviderType;

/**
 * The base model interface for the CommerceAccountGroupCommerceAccountRel service. Represents a row in the &quot;CAccountGroupCAccountRel&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation <code>com.liferay.commerce.account.model.impl.CommerceAccountGroupCommerceAccountRelModelImpl</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in <code>com.liferay.commerce.account.model.impl.CommerceAccountGroupCommerceAccountRelImpl</code>.
 * </p>
 *
 * @author Marco Leo
 * @see CommerceAccountGroupCommerceAccountRel
 * @generated
 */
@ProviderType
public interface CommerceAccountGroupCommerceAccountRelModel
	extends AuditedModel, BaseModel<CommerceAccountGroupCommerceAccountRel>,
			ShardedModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this interface directly. All methods that expect a commerce account group commerce account rel model instance should use the {@link CommerceAccountGroupCommerceAccountRel} interface instead.
	 */

	/**
	 * Returns the primary key of this commerce account group commerce account rel.
	 *
	 * @return the primary key of this commerce account group commerce account rel
	 */
	public long getPrimaryKey();

	/**
	 * Sets the primary key of this commerce account group commerce account rel.
	 *
	 * @param primaryKey the primary key of this commerce account group commerce account rel
	 */
	public void setPrimaryKey(long primaryKey);

	/**
	 * Returns the external reference code of this commerce account group commerce account rel.
	 *
	 * @return the external reference code of this commerce account group commerce account rel
	 */
	@AutoEscape
	public String getExternalReferenceCode();

	/**
	 * Sets the external reference code of this commerce account group commerce account rel.
	 *
	 * @param externalReferenceCode the external reference code of this commerce account group commerce account rel
	 */
	public void setExternalReferenceCode(String externalReferenceCode);

	/**
	 * Returns the commerce account group commerce account rel ID of this commerce account group commerce account rel.
	 *
	 * @return the commerce account group commerce account rel ID of this commerce account group commerce account rel
	 */
	public long getCommerceAccountGroupCommerceAccountRelId();

	/**
	 * Sets the commerce account group commerce account rel ID of this commerce account group commerce account rel.
	 *
	 * @param commerceAccountGroupCommerceAccountRelId the commerce account group commerce account rel ID of this commerce account group commerce account rel
	 */
	public void setCommerceAccountGroupCommerceAccountRelId(
		long commerceAccountGroupCommerceAccountRelId);

	/**
	 * Returns the company ID of this commerce account group commerce account rel.
	 *
	 * @return the company ID of this commerce account group commerce account rel
	 */
	@Override
	public long getCompanyId();

	/**
	 * Sets the company ID of this commerce account group commerce account rel.
	 *
	 * @param companyId the company ID of this commerce account group commerce account rel
	 */
	@Override
	public void setCompanyId(long companyId);

	/**
	 * Returns the user ID of this commerce account group commerce account rel.
	 *
	 * @return the user ID of this commerce account group commerce account rel
	 */
	@Override
	public long getUserId();

	/**
	 * Sets the user ID of this commerce account group commerce account rel.
	 *
	 * @param userId the user ID of this commerce account group commerce account rel
	 */
	@Override
	public void setUserId(long userId);

	/**
	 * Returns the user uuid of this commerce account group commerce account rel.
	 *
	 * @return the user uuid of this commerce account group commerce account rel
	 */
	@Override
	public String getUserUuid();

	/**
	 * Sets the user uuid of this commerce account group commerce account rel.
	 *
	 * @param userUuid the user uuid of this commerce account group commerce account rel
	 */
	@Override
	public void setUserUuid(String userUuid);

	/**
	 * Returns the user name of this commerce account group commerce account rel.
	 *
	 * @return the user name of this commerce account group commerce account rel
	 */
	@AutoEscape
	@Override
	public String getUserName();

	/**
	 * Sets the user name of this commerce account group commerce account rel.
	 *
	 * @param userName the user name of this commerce account group commerce account rel
	 */
	@Override
	public void setUserName(String userName);

	/**
	 * Returns the create date of this commerce account group commerce account rel.
	 *
	 * @return the create date of this commerce account group commerce account rel
	 */
	@Override
	public Date getCreateDate();

	/**
	 * Sets the create date of this commerce account group commerce account rel.
	 *
	 * @param createDate the create date of this commerce account group commerce account rel
	 */
	@Override
	public void setCreateDate(Date createDate);

	/**
	 * Returns the modified date of this commerce account group commerce account rel.
	 *
	 * @return the modified date of this commerce account group commerce account rel
	 */
	@Override
	public Date getModifiedDate();

	/**
	 * Sets the modified date of this commerce account group commerce account rel.
	 *
	 * @param modifiedDate the modified date of this commerce account group commerce account rel
	 */
	@Override
	public void setModifiedDate(Date modifiedDate);

	/**
	 * Returns the commerce account group ID of this commerce account group commerce account rel.
	 *
	 * @return the commerce account group ID of this commerce account group commerce account rel
	 */
	public long getCommerceAccountGroupId();

	/**
	 * Sets the commerce account group ID of this commerce account group commerce account rel.
	 *
	 * @param commerceAccountGroupId the commerce account group ID of this commerce account group commerce account rel
	 */
	public void setCommerceAccountGroupId(long commerceAccountGroupId);

	/**
	 * Returns the commerce account ID of this commerce account group commerce account rel.
	 *
	 * @return the commerce account ID of this commerce account group commerce account rel
	 */
	public long getCommerceAccountId();

	/**
	 * Sets the commerce account ID of this commerce account group commerce account rel.
	 *
	 * @param commerceAccountId the commerce account ID of this commerce account group commerce account rel
	 */
	public void setCommerceAccountId(long commerceAccountId);

	@Override
	public CommerceAccountGroupCommerceAccountRel cloneWithOriginalValues();

}