/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.SecureScoreControlProfile;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.ISecureScoreControlProfileCollectionPage;
import com.microsoft.graph.requests.extensions.ISecureScoreControlProfileCollectionRequest;
import com.microsoft.graph.requests.extensions.SecureScoreControlProfileCollectionPage;
import com.microsoft.graph.requests.extensions.SecureScoreControlProfileCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.SecureScoreControlProfileCollectionResponse;
import com.microsoft.graph.requests.extensions.SecureScoreControlProfileRequestBuilder;
import java.util.List;

public class SecureScoreControlProfileCollectionRequest
extends BaseCollectionRequest<SecureScoreControlProfileCollectionResponse, ISecureScoreControlProfileCollectionPage>
implements ISecureScoreControlProfileCollectionRequest {
    public SecureScoreControlProfileCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, SecureScoreControlProfileCollectionResponse.class, ISecureScoreControlProfileCollectionPage.class);
    }

    @Override
    public void get(final ICallback<ISecureScoreControlProfileCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(SecureScoreControlProfileCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public ISecureScoreControlProfileCollectionPage get() throws ClientException {
        SecureScoreControlProfileCollectionResponse response = (SecureScoreControlProfileCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(SecureScoreControlProfile newSecureScoreControlProfile, ICallback<SecureScoreControlProfile> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new SecureScoreControlProfileRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newSecureScoreControlProfile, callback);
    }

    @Override
    public SecureScoreControlProfile post(SecureScoreControlProfile newSecureScoreControlProfile) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new SecureScoreControlProfileRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newSecureScoreControlProfile);
    }

    @Override
    public ISecureScoreControlProfileCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public ISecureScoreControlProfileCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public ISecureScoreControlProfileCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    public ISecureScoreControlProfileCollectionPage buildFromResponse(SecureScoreControlProfileCollectionResponse response) {
        SecureScoreControlProfileCollectionRequestBuilder builder = response.nextLink != null ? new SecureScoreControlProfileCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        SecureScoreControlProfileCollectionPage page = new SecureScoreControlProfileCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

