/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.Extension;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.ExtensionCollectionPage;
import com.microsoft.graph.requests.extensions.ExtensionCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.ExtensionCollectionResponse;
import com.microsoft.graph.requests.extensions.ExtensionRequestBuilder;
import com.microsoft.graph.requests.extensions.IExtensionCollectionPage;
import com.microsoft.graph.requests.extensions.IExtensionCollectionRequest;
import java.util.List;

public class ExtensionCollectionRequest
extends BaseCollectionRequest<ExtensionCollectionResponse, IExtensionCollectionPage>
implements IExtensionCollectionRequest {
    public ExtensionCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, ExtensionCollectionResponse.class, IExtensionCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IExtensionCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(ExtensionCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IExtensionCollectionPage get() throws ClientException {
        ExtensionCollectionResponse response = (ExtensionCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(Extension newExtension, ICallback<Extension> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new ExtensionRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newExtension, callback);
    }

    @Override
    public Extension post(Extension newExtension) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new ExtensionRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newExtension);
    }

    @Override
    public IExtensionCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IExtensionCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IExtensionCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    public IExtensionCollectionPage buildFromResponse(ExtensionCollectionResponse response) {
        ExtensionCollectionRequestBuilder builder = response.nextLink != null ? new ExtensionCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        ExtensionCollectionPage page = new ExtensionCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

