/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.wsrp.model.impl;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.wsrp.model.WSRPConsumerPortlet;
import com.liferay.wsrp.model.WSRPConsumerPortletModel;

import java.io.Serializable;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;

import java.sql.Blob;
import java.sql.Types;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the WSRPConsumerPortlet service. Represents a row in the &quot;WSRP_WSRPConsumerPortlet&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>WSRPConsumerPortletModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link WSRPConsumerPortletImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see WSRPConsumerPortletImpl
 * @generated
 */
public class WSRPConsumerPortletModelImpl
	extends BaseModelImpl<WSRPConsumerPortlet>
	implements WSRPConsumerPortletModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a wsrp consumer portlet model instance should use the <code>WSRPConsumerPortlet</code> interface instead.
	 */
	public static final String TABLE_NAME = "WSRP_WSRPConsumerPortlet";

	public static final Object[][] TABLE_COLUMNS = {
		{"uuid_", Types.VARCHAR}, {"wsrpConsumerPortletId", Types.BIGINT},
		{"companyId", Types.BIGINT}, {"createDate", Types.TIMESTAMP},
		{"modifiedDate", Types.TIMESTAMP}, {"wsrpConsumerId", Types.BIGINT},
		{"name", Types.VARCHAR}, {"portletHandle", Types.VARCHAR},
		{"lastPublishDate", Types.TIMESTAMP}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("uuid_", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("wsrpConsumerPortletId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("createDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("modifiedDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("wsrpConsumerId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("name", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("portletHandle", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("lastPublishDate", Types.TIMESTAMP);
	}

	public static final String TABLE_SQL_CREATE =
		"create table WSRP_WSRPConsumerPortlet (uuid_ VARCHAR(75) null,wsrpConsumerPortletId LONG not null primary key,companyId LONG,createDate DATE null,modifiedDate DATE null,wsrpConsumerId LONG,name VARCHAR(75) null,portletHandle VARCHAR(255) null,lastPublishDate DATE null)";

	public static final String TABLE_SQL_DROP =
		"drop table WSRP_WSRPConsumerPortlet";

	public static final String ORDER_BY_JPQL =
		" ORDER BY wsrpConsumerPortlet.name ASC";

	public static final String ORDER_BY_SQL =
		" ORDER BY WSRP_WSRPConsumerPortlet.name ASC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	public static final boolean ENTITY_CACHE_ENABLED = GetterUtil.getBoolean(
		com.liferay.wsrp.service.util.ServiceProps.get(
			"value.object.entity.cache.enabled.com.liferay.wsrp.model.WSRPConsumerPortlet"),
		true);

	public static final boolean FINDER_CACHE_ENABLED = GetterUtil.getBoolean(
		com.liferay.wsrp.service.util.ServiceProps.get(
			"value.object.finder.cache.enabled.com.liferay.wsrp.model.WSRPConsumerPortlet"),
		true);

	public static final boolean COLUMN_BITMASK_ENABLED = GetterUtil.getBoolean(
		com.liferay.wsrp.service.util.ServiceProps.get(
			"value.object.column.bitmask.enabled.com.liferay.wsrp.model.WSRPConsumerPortlet"),
		true);

	public static final long COMPANYID_COLUMN_BITMASK = 1L;

	public static final long PORTLETHANDLE_COLUMN_BITMASK = 2L;

	public static final long UUID_COLUMN_BITMASK = 4L;

	public static final long WSRPCONSUMERID_COLUMN_BITMASK = 8L;

	public static final long NAME_COLUMN_BITMASK = 16L;

	public static final long LOCK_EXPIRATION_TIME = GetterUtil.getLong(
		com.liferay.wsrp.service.util.ServiceProps.get(
			"lock.expiration.time.com.liferay.wsrp.model.WSRPConsumerPortlet"));

	public WSRPConsumerPortletModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _wsrpConsumerPortletId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setWsrpConsumerPortletId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _wsrpConsumerPortletId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return WSRPConsumerPortlet.class;
	}

	@Override
	public String getModelClassName() {
		return WSRPConsumerPortlet.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<WSRPConsumerPortlet, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		for (Map.Entry<String, Function<WSRPConsumerPortlet, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<WSRPConsumerPortlet, Object> attributeGetterFunction =
				entry.getValue();

			attributes.put(
				attributeName,
				attributeGetterFunction.apply((WSRPConsumerPortlet)this));
		}

		attributes.put("entityCacheEnabled", isEntityCacheEnabled());
		attributes.put("finderCacheEnabled", isFinderCacheEnabled());

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<WSRPConsumerPortlet, Object>>
			attributeSetterBiConsumers = getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<WSRPConsumerPortlet, Object> attributeSetterBiConsumer =
				attributeSetterBiConsumers.get(attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept(
					(WSRPConsumerPortlet)this, entry.getValue());
			}
		}
	}

	public Map<String, Function<WSRPConsumerPortlet, Object>>
		getAttributeGetterFunctions() {

		return _attributeGetterFunctions;
	}

	public Map<String, BiConsumer<WSRPConsumerPortlet, Object>>
		getAttributeSetterBiConsumers() {

		return _attributeSetterBiConsumers;
	}

	private static Function<InvocationHandler, WSRPConsumerPortlet>
		_getProxyProviderFunction() {

		Class<?> proxyClass = ProxyUtil.getProxyClass(
			WSRPConsumerPortlet.class.getClassLoader(),
			WSRPConsumerPortlet.class, ModelWrapper.class);

		try {
			Constructor<WSRPConsumerPortlet> constructor =
				(Constructor<WSRPConsumerPortlet>)proxyClass.getConstructor(
					InvocationHandler.class);

			return invocationHandler -> {
				try {
					return constructor.newInstance(invocationHandler);
				}
				catch (ReflectiveOperationException
							reflectiveOperationException) {

					throw new InternalError(reflectiveOperationException);
				}
			};
		}
		catch (NoSuchMethodException noSuchMethodException) {
			throw new InternalError(noSuchMethodException);
		}
	}

	private static final Map<String, Function<WSRPConsumerPortlet, Object>>
		_attributeGetterFunctions;

	static {
		Map<String, Function<WSRPConsumerPortlet, Object>>
			attributeGetterFunctions =
				new LinkedHashMap
					<String, Function<WSRPConsumerPortlet, Object>>();

		attributeGetterFunctions.put(
			"uuid",
			new Function<WSRPConsumerPortlet, Object>() {

				@Override
				public Object apply(WSRPConsumerPortlet wsrpConsumerPortlet) {
					return wsrpConsumerPortlet.getUuid();
				}

			});
		attributeGetterFunctions.put(
			"wsrpConsumerPortletId",
			new Function<WSRPConsumerPortlet, Object>() {

				@Override
				public Object apply(WSRPConsumerPortlet wsrpConsumerPortlet) {
					return wsrpConsumerPortlet.getWsrpConsumerPortletId();
				}

			});
		attributeGetterFunctions.put(
			"companyId",
			new Function<WSRPConsumerPortlet, Object>() {

				@Override
				public Object apply(WSRPConsumerPortlet wsrpConsumerPortlet) {
					return wsrpConsumerPortlet.getCompanyId();
				}

			});
		attributeGetterFunctions.put(
			"createDate",
			new Function<WSRPConsumerPortlet, Object>() {

				@Override
				public Object apply(WSRPConsumerPortlet wsrpConsumerPortlet) {
					return wsrpConsumerPortlet.getCreateDate();
				}

			});
		attributeGetterFunctions.put(
			"modifiedDate",
			new Function<WSRPConsumerPortlet, Object>() {

				@Override
				public Object apply(WSRPConsumerPortlet wsrpConsumerPortlet) {
					return wsrpConsumerPortlet.getModifiedDate();
				}

			});
		attributeGetterFunctions.put(
			"wsrpConsumerId",
			new Function<WSRPConsumerPortlet, Object>() {

				@Override
				public Object apply(WSRPConsumerPortlet wsrpConsumerPortlet) {
					return wsrpConsumerPortlet.getWsrpConsumerId();
				}

			});
		attributeGetterFunctions.put(
			"name",
			new Function<WSRPConsumerPortlet, Object>() {

				@Override
				public Object apply(WSRPConsumerPortlet wsrpConsumerPortlet) {
					return wsrpConsumerPortlet.getName();
				}

			});
		attributeGetterFunctions.put(
			"portletHandle",
			new Function<WSRPConsumerPortlet, Object>() {

				@Override
				public Object apply(WSRPConsumerPortlet wsrpConsumerPortlet) {
					return wsrpConsumerPortlet.getPortletHandle();
				}

			});
		attributeGetterFunctions.put(
			"lastPublishDate",
			new Function<WSRPConsumerPortlet, Object>() {

				@Override
				public Object apply(WSRPConsumerPortlet wsrpConsumerPortlet) {
					return wsrpConsumerPortlet.getLastPublishDate();
				}

			});

		_attributeGetterFunctions = Collections.unmodifiableMap(
			attributeGetterFunctions);
	}

	private static final Map<String, BiConsumer<WSRPConsumerPortlet, Object>>
		_attributeSetterBiConsumers;

	static {
		Map<String, BiConsumer<WSRPConsumerPortlet, ?>>
			attributeSetterBiConsumers =
				new LinkedHashMap<String, BiConsumer<WSRPConsumerPortlet, ?>>();

		attributeSetterBiConsumers.put(
			"uuid",
			new BiConsumer<WSRPConsumerPortlet, Object>() {

				@Override
				public void accept(
					WSRPConsumerPortlet wsrpConsumerPortlet,
					Object uuidObject) {

					wsrpConsumerPortlet.setUuid((String)uuidObject);
				}

			});
		attributeSetterBiConsumers.put(
			"wsrpConsumerPortletId",
			new BiConsumer<WSRPConsumerPortlet, Object>() {

				@Override
				public void accept(
					WSRPConsumerPortlet wsrpConsumerPortlet,
					Object wsrpConsumerPortletIdObject) {

					wsrpConsumerPortlet.setWsrpConsumerPortletId(
						(Long)wsrpConsumerPortletIdObject);
				}

			});
		attributeSetterBiConsumers.put(
			"companyId",
			new BiConsumer<WSRPConsumerPortlet, Object>() {

				@Override
				public void accept(
					WSRPConsumerPortlet wsrpConsumerPortlet,
					Object companyIdObject) {

					wsrpConsumerPortlet.setCompanyId((Long)companyIdObject);
				}

			});
		attributeSetterBiConsumers.put(
			"createDate",
			new BiConsumer<WSRPConsumerPortlet, Object>() {

				@Override
				public void accept(
					WSRPConsumerPortlet wsrpConsumerPortlet,
					Object createDateObject) {

					wsrpConsumerPortlet.setCreateDate((Date)createDateObject);
				}

			});
		attributeSetterBiConsumers.put(
			"modifiedDate",
			new BiConsumer<WSRPConsumerPortlet, Object>() {

				@Override
				public void accept(
					WSRPConsumerPortlet wsrpConsumerPortlet,
					Object modifiedDateObject) {

					wsrpConsumerPortlet.setModifiedDate(
						(Date)modifiedDateObject);
				}

			});
		attributeSetterBiConsumers.put(
			"wsrpConsumerId",
			new BiConsumer<WSRPConsumerPortlet, Object>() {

				@Override
				public void accept(
					WSRPConsumerPortlet wsrpConsumerPortlet,
					Object wsrpConsumerIdObject) {

					wsrpConsumerPortlet.setWsrpConsumerId(
						(Long)wsrpConsumerIdObject);
				}

			});
		attributeSetterBiConsumers.put(
			"name",
			new BiConsumer<WSRPConsumerPortlet, Object>() {

				@Override
				public void accept(
					WSRPConsumerPortlet wsrpConsumerPortlet,
					Object nameObject) {

					wsrpConsumerPortlet.setName((String)nameObject);
				}

			});
		attributeSetterBiConsumers.put(
			"portletHandle",
			new BiConsumer<WSRPConsumerPortlet, Object>() {

				@Override
				public void accept(
					WSRPConsumerPortlet wsrpConsumerPortlet,
					Object portletHandleObject) {

					wsrpConsumerPortlet.setPortletHandle(
						(String)portletHandleObject);
				}

			});
		attributeSetterBiConsumers.put(
			"lastPublishDate",
			new BiConsumer<WSRPConsumerPortlet, Object>() {

				@Override
				public void accept(
					WSRPConsumerPortlet wsrpConsumerPortlet,
					Object lastPublishDateObject) {

					wsrpConsumerPortlet.setLastPublishDate(
						(Date)lastPublishDateObject);
				}

			});

		_attributeSetterBiConsumers = Collections.unmodifiableMap(
			(Map)attributeSetterBiConsumers);
	}

	@Override
	public String getUuid() {
		if (_uuid == null) {
			return "";
		}
		else {
			return _uuid;
		}
	}

	@Override
	public void setUuid(String uuid) {
		_columnBitmask |= UUID_COLUMN_BITMASK;

		if (_originalUuid == null) {
			_originalUuid = _uuid;
		}

		_uuid = uuid;
	}

	public String getOriginalUuid() {
		return GetterUtil.getString(_originalUuid);
	}

	@Override
	public long getWsrpConsumerPortletId() {
		return _wsrpConsumerPortletId;
	}

	@Override
	public void setWsrpConsumerPortletId(long wsrpConsumerPortletId) {
		_wsrpConsumerPortletId = wsrpConsumerPortletId;
	}

	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		_columnBitmask |= COMPANYID_COLUMN_BITMASK;

		if (!_setOriginalCompanyId) {
			_setOriginalCompanyId = true;

			_originalCompanyId = _companyId;
		}

		_companyId = companyId;
	}

	public long getOriginalCompanyId() {
		return _originalCompanyId;
	}

	@Override
	public Date getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(Date createDate) {
		_createDate = createDate;
	}

	@Override
	public Date getModifiedDate() {
		return _modifiedDate;
	}

	public boolean hasSetModifiedDate() {
		return _setModifiedDate;
	}

	@Override
	public void setModifiedDate(Date modifiedDate) {
		_setModifiedDate = true;

		_modifiedDate = modifiedDate;
	}

	@Override
	public long getWsrpConsumerId() {
		return _wsrpConsumerId;
	}

	@Override
	public void setWsrpConsumerId(long wsrpConsumerId) {
		_columnBitmask |= WSRPCONSUMERID_COLUMN_BITMASK;

		if (!_setOriginalWsrpConsumerId) {
			_setOriginalWsrpConsumerId = true;

			_originalWsrpConsumerId = _wsrpConsumerId;
		}

		_wsrpConsumerId = wsrpConsumerId;
	}

	public long getOriginalWsrpConsumerId() {
		return _originalWsrpConsumerId;
	}

	@Override
	public String getName() {
		if (_name == null) {
			return "";
		}
		else {
			return _name;
		}
	}

	@Override
	public void setName(String name) {
		_columnBitmask = -1L;

		_name = name;
	}

	@Override
	public String getPortletHandle() {
		if (_portletHandle == null) {
			return "";
		}
		else {
			return _portletHandle;
		}
	}

	@Override
	public void setPortletHandle(String portletHandle) {
		_columnBitmask |= PORTLETHANDLE_COLUMN_BITMASK;

		if (_originalPortletHandle == null) {
			_originalPortletHandle = _portletHandle;
		}

		_portletHandle = portletHandle;
	}

	public String getOriginalPortletHandle() {
		return GetterUtil.getString(_originalPortletHandle);
	}

	@Override
	public Date getLastPublishDate() {
		return _lastPublishDate;
	}

	@Override
	public void setLastPublishDate(Date lastPublishDate) {
		_lastPublishDate = lastPublishDate;
	}

	@Override
	public StagedModelType getStagedModelType() {
		return new StagedModelType(
			PortalUtil.getClassNameId(WSRPConsumerPortlet.class.getName()));
	}

	public long getColumnBitmask() {
		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), WSRPConsumerPortlet.class.getName(),
			getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public WSRPConsumerPortlet toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, WSRPConsumerPortlet>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		WSRPConsumerPortletImpl wsrpConsumerPortletImpl =
			new WSRPConsumerPortletImpl();

		wsrpConsumerPortletImpl.setUuid(getUuid());
		wsrpConsumerPortletImpl.setWsrpConsumerPortletId(
			getWsrpConsumerPortletId());
		wsrpConsumerPortletImpl.setCompanyId(getCompanyId());
		wsrpConsumerPortletImpl.setCreateDate(getCreateDate());
		wsrpConsumerPortletImpl.setModifiedDate(getModifiedDate());
		wsrpConsumerPortletImpl.setWsrpConsumerId(getWsrpConsumerId());
		wsrpConsumerPortletImpl.setName(getName());
		wsrpConsumerPortletImpl.setPortletHandle(getPortletHandle());
		wsrpConsumerPortletImpl.setLastPublishDate(getLastPublishDate());

		wsrpConsumerPortletImpl.resetOriginalValues();

		return wsrpConsumerPortletImpl;
	}

	@Override
	public int compareTo(WSRPConsumerPortlet wsrpConsumerPortlet) {
		int value = 0;

		value = getName().compareTo(wsrpConsumerPortlet.getName());

		if (value != 0) {
			return value;
		}

		return 0;
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof WSRPConsumerPortlet)) {
			return false;
		}

		WSRPConsumerPortlet wsrpConsumerPortlet = (WSRPConsumerPortlet)object;

		long primaryKey = wsrpConsumerPortlet.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	@Override
	public boolean isEntityCacheEnabled() {
		return ENTITY_CACHE_ENABLED;
	}

	@Override
	public boolean isFinderCacheEnabled() {
		return FINDER_CACHE_ENABLED;
	}

	@Override
	public void resetOriginalValues() {
		_originalUuid = _uuid;

		_originalCompanyId = _companyId;

		_setOriginalCompanyId = false;

		_setModifiedDate = false;
		_originalWsrpConsumerId = _wsrpConsumerId;

		_setOriginalWsrpConsumerId = false;

		_originalPortletHandle = _portletHandle;

		_columnBitmask = 0;
	}

	@Override
	public CacheModel<WSRPConsumerPortlet> toCacheModel() {
		WSRPConsumerPortletCacheModel wsrpConsumerPortletCacheModel =
			new WSRPConsumerPortletCacheModel();

		wsrpConsumerPortletCacheModel.uuid = getUuid();

		String uuid = wsrpConsumerPortletCacheModel.uuid;

		if ((uuid != null) && (uuid.length() == 0)) {
			wsrpConsumerPortletCacheModel.uuid = null;
		}

		wsrpConsumerPortletCacheModel.wsrpConsumerPortletId =
			getWsrpConsumerPortletId();

		wsrpConsumerPortletCacheModel.companyId = getCompanyId();

		Date createDate = getCreateDate();

		if (createDate != null) {
			wsrpConsumerPortletCacheModel.createDate = createDate.getTime();
		}
		else {
			wsrpConsumerPortletCacheModel.createDate = Long.MIN_VALUE;
		}

		Date modifiedDate = getModifiedDate();

		if (modifiedDate != null) {
			wsrpConsumerPortletCacheModel.modifiedDate = modifiedDate.getTime();
		}
		else {
			wsrpConsumerPortletCacheModel.modifiedDate = Long.MIN_VALUE;
		}

		wsrpConsumerPortletCacheModel.wsrpConsumerId = getWsrpConsumerId();

		wsrpConsumerPortletCacheModel.name = getName();

		String name = wsrpConsumerPortletCacheModel.name;

		if ((name != null) && (name.length() == 0)) {
			wsrpConsumerPortletCacheModel.name = null;
		}

		wsrpConsumerPortletCacheModel.portletHandle = getPortletHandle();

		String portletHandle = wsrpConsumerPortletCacheModel.portletHandle;

		if ((portletHandle != null) && (portletHandle.length() == 0)) {
			wsrpConsumerPortletCacheModel.portletHandle = null;
		}

		Date lastPublishDate = getLastPublishDate();

		if (lastPublishDate != null) {
			wsrpConsumerPortletCacheModel.lastPublishDate =
				lastPublishDate.getTime();
		}
		else {
			wsrpConsumerPortletCacheModel.lastPublishDate = Long.MIN_VALUE;
		}

		return wsrpConsumerPortletCacheModel;
	}

	@Override
	public String toString() {
		Map<String, Function<WSRPConsumerPortlet, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 2);

		sb.append("{");

		for (Map.Entry<String, Function<WSRPConsumerPortlet, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<WSRPConsumerPortlet, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("\"");
			sb.append(attributeName);
			sb.append("\": ");

			Object value = attributeGetterFunction.apply(
				(WSRPConsumerPortlet)this);

			if (value == null) {
				sb.append("null");
			}
			else if (value instanceof Blob || value instanceof Date ||
					 value instanceof Map || value instanceof String) {

				sb.append(
					"\"" + StringUtil.replace(value.toString(), "\"", "'") +
						"\"");
			}
			else {
				sb.append(value);
			}

			sb.append(", ");
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append("}");

		return sb.toString();
	}

	@Override
	public String toXmlString() {
		Map<String, Function<WSRPConsumerPortlet, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 4);

		sb.append("<model><model-name>");
		sb.append(getModelClassName());
		sb.append("</model-name>");

		for (Map.Entry<String, Function<WSRPConsumerPortlet, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<WSRPConsumerPortlet, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("<column><column-name>");
			sb.append(attributeName);
			sb.append("</column-name><column-value><![CDATA[");
			sb.append(attributeGetterFunction.apply((WSRPConsumerPortlet)this));
			sb.append("]]></column-value></column>");
		}

		sb.append("</model>");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function<InvocationHandler, WSRPConsumerPortlet>
			_escapedModelProxyProviderFunction = _getProxyProviderFunction();

	}

	private String _uuid;
	private String _originalUuid;
	private long _wsrpConsumerPortletId;
	private long _companyId;
	private long _originalCompanyId;
	private boolean _setOriginalCompanyId;
	private Date _createDate;
	private Date _modifiedDate;
	private boolean _setModifiedDate;
	private long _wsrpConsumerId;
	private long _originalWsrpConsumerId;
	private boolean _setOriginalWsrpConsumerId;
	private String _name;
	private String _portletHandle;
	private String _originalPortletHandle;
	private Date _lastPublishDate;
	private long _columnBitmask;
	private WSRPConsumerPortlet _escapedModel;

}